package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.collect.Lists;
import com.rocogz.syy.common.entity.Account;
import com.rocogz.syy.infrastructure.entity.permission.Permission;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.entity.role.Role;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;


/**
 * <p>
 * 管理员账号表
 * </p>
 *
 * @author liangyongtong
 * @since 2020-01-14
 */
@SuppressWarnings("all")
@TableName(value = "basic_system_admin_user")
public class AdminUser extends Account {

    private static final long serialVersionUID=1L;

    public AdminUser() {
    }

    public AdminUser(Integer id) {
        this.id = id;
    }


    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 状态
     */
    private String status;

    /**
     * 检索字段
     */
    private String keyword;

    /**
     * 是否删除
     */
    private Boolean deleted;

    /**
     * 所属角色
     */
    private transient List<Role> roles;

    /**
     * 是否已激活 Y/N
     */
    private String active;

    /**
     * 是否更新过初始密码 Y/N
     */
    private String uppass;

    /**
     * 角色id集合  (用于接收前端传过来的角色id)
     */
    private transient List<String> roleId;

    /**
     * 用户数据权限
     */
    private transient List<UserDataPermission> userDataPermissions;


    public List<UserDataPermission> getUserDataPermissions() {
        return userDataPermissions;
    }

    public void setUserDataPermissions(List<UserDataPermission> userDataPermissions) {
        this.userDataPermissions = userDataPermissions;
    }


    public List<String> getRoleId() {
        return roleId;
    }

    public void setRoleId(List<String> roleId) {
        this.roleId = roleId;
    }

    /**
     * 获取用户角色名称
     *
     * @return
     */
    public List<String> getRoleNameList() {
        if (CollectionUtils.isEmpty(roles)) {
            return Collections.emptyList();
        }

        ArrayList<String> roleNames = Lists.newArrayListWithCapacity(roles.size());
        for (Role role : roles) {
            roleNames.add(role.getName());
        }

        return roleNames;
    }

    /**
     * 获取用户权限
     *
     * @return
     */
    public LinkedHashSet<String> getPermissions() {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(roles)) {
            for (Role role : roles) {
                List<Permission> permission = role.getPermission();
                if (permission != null) {
                    for (Permission perm : permission) {
                        permissions.add(perm.getViewPermission());
                        permissions.add(perm.getUrlPermission());
                    }
                }
            }
        }
        return permissions;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<Role> getRoles() {
        return roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public String getActive() {
        return active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getUppass() {
        return uppass;
    }

    public void setUppass(String uppass) {
        this.uppass = uppass;
    }
}
