package com.rocogz.syy.infrastructure.entity.prefecture;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-专区表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-03-27
 */
@TableName("basic_prefecture")
public class Prefecture extends IdEntity {

    private static final long serialVersionUID = 3411363957722392675L;
    /**
     * 父级专区编码,父级专区编码为0的为顶级区域
     */
    private String parentCode;

    /**
     * 专区编码
     */
    private String code;

    /**
     * 专区名称
     */
    private String name;

    /**
     * 状态
     */
    private String status;

    /**
     * 开通服务状态
     */
    private String openServiceStatus;

    /**
     * 专区说明
     */
    private String description;

    /**
     * 创建时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 更新人
     */
    private Integer updateUser;


    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOpenServiceStatus() {
        return openServiceStatus;
    }

    public void setOpenServiceStatus(String openServiceStatus) {
        this.openServiceStatus = openServiceStatus;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Integer createUser) {
        this.createUser = createUser;
    }

    public Integer getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Integer updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public String toString() {
        return "BasicPrefecture{" +
        "parentCode=" + parentCode +
        ", code=" + code +
        ", name=" + name +
        ", status=" + status +
        ", openServiceStatus=" + openServiceStatus +
        ", description=" + description +
        ", createTime=" + createTime +
        ", updateTime=" + updateTime +
        ", createUser=" + createUser +
        ", updateUser=" + updateUser +
        "}";
    }
}
