/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.infrastructure.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.log.ApiRequestLogStatisticsResponseDto;
import com.rocogz.syy.infrastructure.dto.login.PlatformUserCipherDto;
import com.rocogz.syy.infrastructure.dto.sms.SmsParamDto;
import com.rocogz.syy.infrastructure.dto.system.SetPermissionDto;
import com.rocogz.syy.infrastructure.dto.tree.CustomMenuTreeDto;
import com.rocogz.syy.infrastructure.dto.tree.MenuTreeDto;
import com.rocogz.syy.infrastructure.dto.tree.PrefectureTreeDto;
import com.rocogz.syy.infrastructure.dto.weixin.SendSubscribeMesDto;
import com.rocogz.syy.infrastructure.dto.weixin.WeixinSubscribeMessageDto;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.apiInfomation.ApiInformation;
import com.rocogz.syy.infrastructure.entity.app.config.BasicWxMiniAppConfig;
import com.rocogz.syy.infrastructure.entity.area.entity.ProvCityArea;
import com.rocogz.syy.infrastructure.entity.dict.DictData;
import com.rocogz.syy.infrastructure.entity.dict.DictLicensePrefix;
import com.rocogz.syy.infrastructure.entity.dict.DictType;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatform;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatformIpAddr;
import com.rocogz.syy.infrastructure.entity.log.AgentApiRequestLog;
import com.rocogz.syy.infrastructure.entity.log.ApiRequestLog;
import com.rocogz.syy.infrastructure.entity.log.MallApiRequestLog;
import com.rocogz.syy.infrastructure.entity.log.MerchantApiRequestLog;
import com.rocogz.syy.infrastructure.entity.mchConfig.BasicWxPaymentMchConfig;
import com.rocogz.syy.infrastructure.entity.menu.CustomMenu;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.entity.platformcipher.PlatformUserCipher;
import com.rocogz.syy.infrastructure.entity.prefecture.Prefecture;
import com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea;
import com.rocogz.syy.infrastructure.entity.role.Role;
import com.rocogz.syy.infrastructure.entity.subscription.entity.BasicWxSubscription;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenAdminUser;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenLoginLog;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenUserinfo;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public interface IInfrastructureClientService {
    @PostMapping(value={"/api/basic/sms/send"})
    public Response<String> sendShortMsg(@RequestBody SmsParamDto var1);

    @GetMapping(value={"/api/basic/prov-city-area/getChildrenByPcode"})
    public Response<List<ProvCityArea>> getProvCityAreaListByPcode(@RequestParam(value="pcode") String var1);

    @GetMapping(value={"/api/basic/prov-city-area/getChildrenByPcodeWithLike"})
    public Response<List<ProvCityArea>> getChildrenByPcodeWithLike(@RequestParam(value="pcode") String var1);

    @GetMapping(value={"/api/dict/data"})
    public Response<List<DictData>> searchDictData(@RequestParam(value="pCode", required=false) String var1, @RequestParam(value="typeCode", required=false) String var2, @RequestParam(value="status", required=false) String var3, @RequestParam(value="code", required=false) String var4, @RequestParam(value="keyword", required=false) String var5);

    @GetMapping(value={"/api/dict/data/{id}"})
    public Response<DictData> getDictData(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/dict/data/status/{id}"})
    public Response switchDictDataStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/dict/data/batchEdit"})
    public Response batchEditDictData(@RequestBody List<DictData> var1);

    @GetMapping(value={"/api/dict/data/get/{typeCode}"})
    public Response<List<DictData>> getDictDataByTypeCode(@PathVariable(value="typeCode") String var1);

    @GetMapping(value={"/api/dict/data/getDictDataByTypeCodeAndStatus/{typeCode}"})
    public Response<List<DictData>> getDictDataByTypeCodeAndStatus(@PathVariable(value="typeCode") String var1, @RequestParam(value="status") String var2);

    @GetMapping(value={"/api/dict/data/getDataByTypeCodeList"})
    public Response<Map<String, List<DictData>>> getDictDataByTypeCodeList(@RequestParam(value="typeCodeList") List<String> var1);

    @GetMapping(value={"/api/dict/data/getDictDataByTypeCodeAndCode"})
    public Response<DictData> getDictDataByTypeCodeAndCode(@RequestParam(value="typeCode") String var1, @RequestParam(value="code") String var2);

    @GetMapping(value={"/api/dict/data/getDictDataByTypeCodeAndName"})
    public Response<DictData> getDictDataByTypeCodeAndName(@RequestParam(value="typeCode") String var1, @RequestParam(value="name") String var2);

    @GetMapping(value={"/api/dict/type"})
    public PageTable<DictType> searchDictType(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/dict/type/{id}"})
    public Response<DictType> getDictType(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/dict/type/status/{id}"})
    public Response switchDictTypeStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/dict/type"})
    public Response saveOrUpdateDictType(DictType var1);

    @GetMapping(value={"/api/dict/type/getDictTypeByTypeCodes"})
    public Response<List<DictType>> getDictDataByTypeCodeAndStatus(@RequestParam(value="typeCodes") List<String> var1, @RequestParam(value="dataStatus", required=false) String var2);

    @GetMapping(value={"/api/basic/prefectureArea/listByPrefectureCode"})
    public Response<List<PrefectureArea>> listPrefectureAreaByPrefectureCode(@RequestParam(value="prefectureCode") String var1);

    @PostMapping(value={"/api/basic/prefectureArea/queryByEntity"})
    public Response<PrefectureArea> queryPrefectureAreaByEntity(@RequestBody PrefectureArea var1);

    @PostMapping(value={"/api/basic/prefectureArea"})
    public Response addPrefectureArea(@RequestBody PrefectureArea var1);

    @PostMapping(value={"/api/basic/prefectureArea/saveBatch"})
    public Response saveBatchPrefectureArea(@RequestBody List<PrefectureArea> var1);

    @DeleteMapping(value={"/api/basic/prefectureArea"})
    public Response removePrefectureArea(@RequestParam(value="id") Integer var1);

    @GetMapping(value={"/api/basic/prefecture/getChild"})
    public Response<List<Prefecture>> getPrefectureChild(@RequestParam(value="prefectureCode") String var1);

    @GetMapping(value={"/api/basic/prefecture/pageQuery"})
    public PageTable<Prefecture> pageQueryPrefecture(@RequestParam(value="code", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="status", required=false) String var3, @RequestParam(value="inCodes", required=false) List<String> var4, @RequestParam(value="page", defaultValue="1") Integer var5, @RequestParam(value="limit", defaultValue="20") Integer var6);

    @GetMapping(value={"/api/basic/prefecture/getTree"})
    public Response<List<PrefectureTreeDto>> getPrefectureTree();

    @GetMapping(value={"/api/basic/prefecture/{id}"})
    public Response<Prefecture> getPrefectureById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/basic/prefecture/getByCode"})
    public Response<Prefecture> getPrefectureByCode(@RequestParam(value="code") String var1);

    @PostMapping(value={"/api/basic/prefecture"})
    public Response saveOrUpdatePrefecture(@RequestBody Prefecture var1);

    @GetMapping(value={"/api/basic/prefecture/findPrefectureList"})
    public Response<List<Prefecture>> findPrefectureList(@RequestParam(value="status", required=false) String var1, @RequestParam(value="openServiceStatus", required=false) String var2, @RequestParam(value="miniAppid", required=false) String var3);

    @GetMapping(value={"/api/basic/prefecture/findPrefectureByCode"})
    public Response<List<Prefecture>> findPrefectureListByCode(@RequestParam(value="code", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="prefectureCodeList") List<String> var3);

    @PostMapping(value={"/api/basic/prefecture/getOneAvailablePrefectureByArea"})
    public Response<Prefecture> getOneAvailablePrefectureByArea(@RequestBody PrefectureArea var1, @RequestParam(value="miniAppid", required=false) String var2);

    @PostMapping(value={"/api/basic/prefecture/listAvailablePrefectureByArea"})
    public Response<List<Prefecture>> listAvailablePrefectureByArea(@RequestBody PrefectureArea var1, @RequestParam(value="miniAppid", required=false) String var2);

    @GetMapping(value={"/api/basic/dockingPlatform"})
    public PageTable<DockingPlatform> findDockingPlatformList(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @PostMapping(value={"/api/basic/dockingPlatform/changeDockingPlatformstatus"})
    public Response changeDockingPlatformstatus(@RequestBody DockingPlatform var1);

    @GetMapping(value={"/api/basic/dockingPlatform/{id}"})
    public Response<DockingPlatform> getDockingPlatformById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/basic/dockingPlatform/getDockingPlatformByCode"})
    public Response<DockingPlatform> getDockingPlatformByCode(@RequestParam(value="code") String var1, @RequestParam(value="status", required=false) String var2);

    @PostMapping(value={"/api/basic/dockingPlatform/saveOrUpdateDockingPlatform"})
    public Response saveOrUpdateDockingPlatform(@RequestBody DockingPlatform var1);

    @GetMapping(value={"/api/basic/dockingPlatform/findDockingPlatformListNoKeyAndIv"})
    public Response<List<DockingPlatform>> findDockingPlatformListNoKeyAndIv(@RequestParam(value="provideCoupon", required=false) String var1, @RequestParam(value="status", required=false) String var2);

    @GetMapping(value={"/api/basic/dockingPlatform/getDockingPlatformByCodeNoKeyAndIv"})
    public Response<DockingPlatform> getDockingPlatformByCodeNoKeyAndIv(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/basic/dockingPlatform/getDockingPlatformListByCodeListNoKeyAndIv"})
    public Response<List<DockingPlatform>> getDockingPlatformListByCodeListNoKeyAndIv(@RequestParam(value="codeList") List<String> var1);

    @GetMapping(value={"/api/basic/apiInfomation/queryApi"})
    public PageTable<ApiInformation> queryApi(@RequestParam(value="platformCode", required=false) String var1, @RequestParam(value="serviceName", required=false) String var2, @RequestParam(value="name", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @GetMapping(value={"/api/basic/apiInfomation/findApiInformationList"})
    public PageTable<ApiInformation> findApiInformationList(@RequestParam(value="serviceName", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @GetMapping(value={"/api/basic/apiInfomation/queryApiList"})
    public PageTable<ApiInformation> queryApiList(@RequestParam(value="limit", defaultValue="20") int var1, @RequestParam(value="page", defaultValue="1") int var2);

    @GetMapping(value={"/api/basic/apiInfomation/deleteApiByPlatformCode"})
    public Response deleteApiByPlatformCode(@RequestParam(value="platformCode") String var1, @RequestParam(value="apiId") Integer var2);

    @GetMapping(value={"/api/basic/apiInfomation/getApiListByPlatformCode"})
    public Response<List<ApiInformation>> getApiListByPlatformCode(@RequestParam(value="platformCode") String var1);

    @GetMapping(value={"/api/basic/apiInfomation/getApiListByPlatformCodeAndStatus"})
    public Response<List<ApiInformation>> getApiListByPlatformCodeAndStatus(@RequestParam(value="platformCode") String var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/basic/apiInfomation/changePlatformApiStatusById/{apiId}"})
    public Response changePlatformApiStatusById(@PathVariable(value="apiId") Integer var1, @RequestParam(value="status") String var2, @RequestParam(value="platformCode") String var3, @RequestParam(value="updateUser") String var4);

    @PostMapping(value={"/api/basic/apiInfomation/addApiListByPlatformCode"})
    public Response addApiListByPlatformCode(@RequestParam(value="apiIdList") List<Integer> var1, @RequestParam(value="platformCode") String var2, @RequestParam(value="updateUser") String var3);

    @RequestMapping(value={"/api/basic/dict/dictLicensePrefix"})
    public Response<DictLicensePrefix> getLicensePrefixByProvCityNameLike(@RequestParam(value="provName") String var1, @RequestParam(value="cityName") String var2);

    @GetMapping(value={"/api/system/users"})
    public PageTable<AdminUser> findAdminUserList(@RequestParam(value="username", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="roleId", required=false) String var3, @RequestParam(value="status", required=false) String var4, @RequestParam(value="type", required=false) String var5, @RequestParam(value="systemCode") String var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/system/users/findMenu"})
    public List<Menu> findMenuByAdminUserId(@RequestParam(value="userId") Integer var1);

    @PostMapping(value={"/api/system/users/findCustomMenu"})
    public List<Menu> findCustomMenuByAdminUserIdAndType(@RequestParam(value="userId") Integer var1, @RequestParam(value="type") String var2);

    @PostMapping(value={"/api/system/users"})
    public Response createAdminUser(AdminUser var1);

    @PostMapping(value={"/api/system/users/edit"})
    public Response editAdminUser(AdminUser var1);

    @GetMapping(value={"/api/system/users/{id}"})
    public Response<AdminUser> getAdminUserById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/users/{id}/password"})
    public Response resetAdminUserPwd(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/users/role/{id}"})
    public Response<List<Role>> getAdminUserRolesById(@PathVariable(value="id") Long var1, @RequestParam(value="systemCode") String var2);

    @PostMapping(value={"/api/system/users/role/{id}"})
    public Response setAdminUserRolesById(@PathVariable(value="id") Long var1, @RequestParam(value="roleIds") long[] var2);

    @PostMapping(value={"/api/system/users/status/{id}"})
    public Response switchAdminUserStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") String var2);

    @GetMapping(value={"/api/system/users/delete/{id}"})
    public Response deleteAdminUserById(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/system/users/password/modify"})
    public Response updateAdminUserPwd(@RequestParam(value="oldPwd") String var1, @RequestParam(value="newPwd") String var2, @RequestParam(value="confirmPwd") String var3, @RequestParam(value="userId") Integer var4);

    @RequestMapping(value={"/api/system/users/batch/open"})
    public Response batchOpenAdminUser(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/system/users/batch/lock"})
    public Response batchLockAdminUser(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/system/users/batch/resetpwd"})
    public Response resetAdminUserPwd(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/system/users/getAllInfoById"})
    public AdminUser getAdminUserAllInfoById(@RequestParam(value="id") Integer var1);

    @PostMapping(value={"/api/system/users/getAllInfoByUsername"})
    public AdminUser getAdminUserAllInfoByUsername(@RequestParam(value="username") String var1, @RequestParam(value="systemCode", required=false) String var2, @RequestParam(value="type") String var3);

    @PostMapping(value={"/api/system/users/active"})
    public Response activeAdminUser(@RequestParam(value="id") Long var1, @RequestParam(value="password") String var2);

    @PostMapping(value={"/api/system/users/names"})
    public Response<List<AdminUser>> queryAccountListByUsenames(@RequestParam(value="systemCode", required=false) String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/api/system/users/getUserListByRoleId/{roleId}"})
    public Response<List<AdminUser>> getUserListByRoleId(@PathVariable(value="roleId") Integer var1);

    @GetMapping(value={"/api/system/users/getByMobile"})
    public Response<List<AdminUser>> getUserByMobile(@RequestParam(value="mobile") String var1, @RequestParam(value="systemCode", required=false) String var2);

    @GetMapping(value={"/api/system/role"})
    public PageTable<Role> pageFindRoleList(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="type", required=false) String var2, @RequestParam(value="systemCode", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @PostMapping(value={"/api/system/role"})
    public Response saveOrUpdateRole(Role var1);

    @GetMapping(value={"/api/system/role/{id}"})
    public Response<Role> getRoleById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/role/delete/{id}"})
    public Response deleteRole(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/system/role/permission/{id}"})
    public Response<List<SetPermissionDto>> findRolePermission(@PathVariable(value="id") Long var1, @RequestParam(value="type", required=false) String var2);

    @PostMapping(value={"/api/system/role/permission/{id}"})
    public Response setRolePermissions(@PathVariable(value="id") Long var1, List<SetPermissionDto> var2);

    @GetMapping(value={"/api/system/role/role/{id}"})
    public Response<List<Role>> getRolesByUserId(@PathVariable(value="id") Long var1, @RequestParam(value="systemCode") String var2);

    @PostMapping(value={"/api/system/role/role/{id}"})
    public Response setRolesByUserId(@PathVariable(value="id") Long var1, @RequestParam(value="roles") long[] var2);

    @GetMapping(value={"/api/system/role/findRoleList"})
    public Response<List<Role>> findRoleList(@RequestParam(value="roleType", required=false) String var1, @RequestParam(value="systemCode", required=false) String var2);

    @GetMapping(value={"/api/menu"})
    public PageTable<Menu> findMenuList(@RequestParam(value="pid") Long var1, @RequestParam(value="systemCode", required=false) String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @GetMapping(value={"/api/menu/findMenuTree"})
    public Response<List<MenuTreeDto>> findMenuTree(@RequestParam(value="systemCode", required=false) String var1);

    @GetMapping(value={"/api/menu/getById/{id}"})
    public Response<Menu> getMenuById(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/menu"})
    public Response editMenu(Menu var1);

    @GetMapping(value={"/api/menu/findAllOpen"})
    public Response<List<Menu>> findAllOpenMenu(@RequestParam(value="systemCode", required=false) String var1);

    @PostMapping(value={"/api/menu/status/{id}"})
    public Response switchStatus(@PathVariable(value="id") Integer var1, @RequestParam(value="status") String var2);

    @GetMapping(value={"/api/custom/menu/findMenuTree"})
    public Response<List<CustomMenuTreeDto>> findCustomMenuTree(@RequestParam(value="type") String var1, @RequestParam(value="systemCode", required=false) String var2);

    @GetMapping(value={"/api/custom/menu/findMenuZTree"})
    public Response<List<Menu>> findCustomMenuZTree(@RequestParam(value="type") String var1, @RequestParam(value="flag") String var2, @RequestParam(value="systemCode", required=false) String var3);

    @PostMapping(value={"/api/custom/menu/update"})
    public Response updateCustomMenu(@RequestBody CustomMenu var1);

    @GetMapping(value={"/api/custom/menu/detail/{id}"})
    public Response<CustomMenu> customMenuDetail(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/custom/menu"})
    public PageTable<CustomMenu> customMenuSearchScrollPage(@RequestParam(value="pid", required=false) Integer var1, @RequestParam(value="type") String var2, @RequestParam(value="systemCode", required=false) String var3, @RequestParam(value="limit") int var4, @RequestParam(value="page") int var5);

    @PostMapping(value={"/api/custom/menu/updateStatus"})
    public Response customMenuUpdateStatus(@RequestBody CustomMenu var1);

    @GetMapping(value={"/api/custom/menu/delete/{id}"})
    public Response customMenuDelete(@PathVariable(value="id") Integer var1);

    @PostMapping(value={"/api/weixin/message/send"})
    public Response sendSubcribeMsg(@RequestBody WeixinSubscribeMessageDto var1);

    @PostMapping(value={"/api/weixin/message/sendAndDelete"})
    public Response sendSubcribeMsgAndDelete(@RequestBody SendSubscribeMesDto var1);

    @GetMapping(value={"/api/weixin/message/subscription/queryInfo"})
    public Response<BasicWxSubscription> getInfoByTemplateIdAndOpenId(@RequestParam(required=false, value="templateId") String var1, @RequestParam(value="openid") String var2, @RequestParam(value="businessCode", required=false) String var3);

    @PostMapping(value={"/api/weixin/message/subscription/saveInfo"})
    public Response saveSubscriptionInfo(@RequestBody BasicWxSubscription var1);

    @GetMapping(value={"/api/weixin/message/subscription/delete"})
    public Response deleteByTemplateIdAndOpenId(@RequestParam(required=false, value="templateId") String var1, @RequestParam(value="openid") String var2, @RequestParam(value="businessCode", required=false) String var3);

    @GetMapping(value={"/api/weixin/message/subscription/deleteByBusinessCodes"})
    public Response deleteByBusinessCodes(@RequestBody List<String> var1);

    @GetMapping(value={"/api/basic/dockingPlatformIpAddr/findDockingPlatformIpAddrList"})
    public Response<List<DockingPlatformIpAddr>> findDockingPlatformIpAddrList(@RequestParam(value="platformCode") String var1);

    @PostMapping(value={"/api/basic/dockingPlatformIpAddr/updateDockingPlatformIpAddrList"})
    public Response updateDockingPlatformIpAddrList(@RequestParam(value="platformCode") String var1, @RequestBody List<DockingPlatformIpAddr> var2);

    @PostMapping(value={"/api/basic/api-request-log"})
    public Response saveApiRequestLog(@RequestBody ApiRequestLog var1);

    @GetMapping(value={"/api/basic/api-request-log/pageQuery"})
    public PageTable<ApiRequestLog> pageQueryApiRequestLog(@RequestParam(value="skyWalkingTid", required=false) String var1, @RequestParam(value="requestUrl", required=false) String var2, @RequestParam(value="requestType", required=false) String var3, @RequestParam(value="usedTimeMin", required=false) Integer var4, @RequestParam(value="usedTimeMax", required=false) Integer var5, @RequestParam(value="currentUserCode", required=false) String var6, @RequestParam(value="currentUserOpenid", required=false) String var7, @RequestParam(value="currentUserMobile", required=false) String var8, @RequestParam(value="className", required=false) String var9, @RequestParam(value="methodName", required=false) String var10, @RequestParam(value="startTime", required=false) LocalDateTime var11, @RequestParam(value="endTime", required=false) LocalDateTime var12, @RequestParam(value="page", defaultValue="1") Integer var13, @RequestParam(value="limit", defaultValue="20") Integer var14);

    @GetMapping(value={"/api/basic/api-request-log/pageQueryDistinctApiRequestInterface"})
    public PageTable<ApiRequestLog> pageQueryDistinctApiRequestInterface(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="requestUrl", required=false) String var3, @RequestParam(value="startTime") LocalDateTime var4, @RequestParam(value="endTime") LocalDateTime var5, @RequestParam(value="page", defaultValue="1") Integer var6, @RequestParam(value="limit", defaultValue="20") Integer var7);

    @GetMapping(value={"/api/basic/api-request-log/getStartTimeAndUsedTimeMillisList"})
    public Response<List<ApiRequestLog>> getStartTimeAndUsedTimeMillisList(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="startTime") LocalDateTime var3, @RequestParam(value="endTime") LocalDateTime var4);

    @GetMapping(value={"/api/basic/api-request-log/statisticsApiMaxAndAverageUserTimeList"})
    public Response<ApiRequestLogStatisticsResponseDto> statisticsApiMaxAndAverageUserTimeList(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2, @RequestParam(value="limit", defaultValue="10") Integer var3);

    @PostMapping(value={"/api/basic/merchant-api-request-log/save"})
    public Response saveMerchantApiRequestLog(@RequestBody MerchantApiRequestLog var1);

    @GetMapping(value={"/api/basic/merchant-api-request-log"})
    public PageTable<MerchantApiRequestLog> findMerchantApiRequestLogs(@RequestParam(value="skyWalkingTid", required=false) String var1, @RequestParam(value="requestUrl", required=false) String var2, @RequestParam(value="usedTimeMin", required=false) Integer var3, @RequestParam(value="usedTimeMax", required=false) Integer var4, @RequestParam(value="currentAccountCode", required=false) String var5, @RequestParam(value="currentUserOpenid", required=false) String var6, @RequestParam(value="currentUserMobile", required=false) String var7, @RequestParam(value="className", required=false) String var8, @RequestParam(value="methodName", required=false) String var9, @RequestParam(value="startTime", required=false) LocalDateTime var10, @RequestParam(value="endTime", required=false) LocalDateTime var11, @RequestParam(value="page", defaultValue="1") Integer var12, @RequestParam(value="limit", defaultValue="20") Integer var13);

    @GetMapping(value={"/api/basic/merchant-api-request-log/distinctHandleMethod"})
    public PageTable<MerchantApiRequestLog> distinctMerchantApiLogHandleMethod(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="requestUrl", required=false) String var3, @RequestParam(value="startTime") LocalDateTime var4, @RequestParam(value="endTime") LocalDateTime var5, @RequestParam(value="page", defaultValue="1") Integer var6, @RequestParam(value="limit", defaultValue="20") Integer var7);

    @GetMapping(value={"/api/basic/merchant-api-request-log/findApiLogList"})
    public Response<List<MerchantApiRequestLog>> findMerchantApiLogListByTimeRange(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="startTime") LocalDateTime var3, @RequestParam(value="endTime") LocalDateTime var4);

    @GetMapping(value={"/api/basic/merchant-api-request-log/statisSpendTopN"})
    public Response<ApiRequestLogStatisticsResponseDto> statisMerchantApiLogMaxAvgSpendTopN(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2, @RequestParam(value="topN", defaultValue="10") Integer var3);

    @PostMapping(value={"/api/basic/mall-api-request-log/save"})
    public Response saveMallApiRequestLog(@RequestBody MallApiRequestLog var1);

    @GetMapping(value={"/api/basic/mall-api-request-log"})
    public PageTable<MallApiRequestLog> findMallApiRequestLogs(@RequestParam(value="skyWalkingTid", required=false) String var1, @RequestParam(value="requestUrl", required=false) String var2, @RequestParam(value="usedTimeMin", required=false) Integer var3, @RequestParam(value="usedTimeMax", required=false) Integer var4, @RequestParam(value="currentAccountCode", required=false) String var5, @RequestParam(value="currentUserOpenid", required=false) String var6, @RequestParam(value="currentUserMobile", required=false) String var7, @RequestParam(value="className", required=false) String var8, @RequestParam(value="methodName", required=false) String var9, @RequestParam(value="startTime", required=false) LocalDateTime var10, @RequestParam(value="endTime", required=false) LocalDateTime var11, @RequestParam(value="page", defaultValue="1") Integer var12, @RequestParam(value="limit", defaultValue="20") Integer var13);

    @GetMapping(value={"/api/basic/mall-api-request-log/distinctHandleMethod"})
    public PageTable<MallApiRequestLog> distinctMallApiLogHandleMethod(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="requestUrl", required=false) String var3, @RequestParam(value="startTime") LocalDateTime var4, @RequestParam(value="endTime") LocalDateTime var5, @RequestParam(value="page", defaultValue="1") Integer var6, @RequestParam(value="limit", defaultValue="20") Integer var7);

    @GetMapping(value={"/api/basic/mall-api-request-log/findApiLogList"})
    public Response<List<MallApiRequestLog>> findMallApiLogListByTimeRange(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="startTime") LocalDateTime var3, @RequestParam(value="endTime") LocalDateTime var4);

    @GetMapping(value={"/api/basic/mall-api-request-log/statisSpendTopN"})
    public Response<ApiRequestLogStatisticsResponseDto> statisMallApiLogMaxAvgSpendTopN(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2, @RequestParam(value="topN", defaultValue="10") Integer var3);

    @PostMapping(value={"/api/basic/agent-api-request-log/save"})
    public Response saveAgentApiRequestLog(@RequestBody AgentApiRequestLog var1);

    @GetMapping(value={"/api/basic/agent-api-request-log"})
    public PageTable<AgentApiRequestLog> findAgentApiRequestLogs(@RequestParam(value="skyWalkingTid", required=false) String var1, @RequestParam(value="requestUrl", required=false) String var2, @RequestParam(value="usedTimeMin", required=false) Integer var3, @RequestParam(value="usedTimeMax", required=false) Integer var4, @RequestParam(value="currentAccountCode", required=false) String var5, @RequestParam(value="currentUserOpenid", required=false) String var6, @RequestParam(value="currentUserMobile", required=false) String var7, @RequestParam(value="className", required=false) String var8, @RequestParam(value="methodName", required=false) String var9, @RequestParam(value="startTime", required=false) LocalDateTime var10, @RequestParam(value="endTime", required=false) LocalDateTime var11, @RequestParam(value="page", defaultValue="1") Integer var12, @RequestParam(value="limit", defaultValue="20") Integer var13);

    @GetMapping(value={"/api/basic/agent-api-request-log/distinctHandleMethod"})
    public PageTable<AgentApiRequestLog> distinctAgentApiLogHandleMethod(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="requestUrl", required=false) String var3, @RequestParam(value="startTime") LocalDateTime var4, @RequestParam(value="endTime") LocalDateTime var5, @RequestParam(value="page", defaultValue="1") Integer var6, @RequestParam(value="limit", defaultValue="20") Integer var7);

    @GetMapping(value={"/api/basic/agent-api-request-log/findApiLogList"})
    public Response<List<AgentApiRequestLog>> findAgentApiLogListByTimeRange(@RequestParam(value="className", required=false) String var1, @RequestParam(value="methodName", required=false) String var2, @RequestParam(value="startTime") LocalDateTime var3, @RequestParam(value="endTime") LocalDateTime var4);

    @GetMapping(value={"/api/basic/agent-api-request-log/statisSpendTopN"})
    public Response<ApiRequestLogStatisticsResponseDto> statisAgentApiLogMaxAvgSpendTopN(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2, @RequestParam(value="topN", defaultValue="10") Integer var3);

    @RequestMapping(value={"/api/system/datapermission/getUserDataPermissionByUserId"})
    public List<UserDataPermission> getUserDataPermissionByUserId(@RequestParam(value="userId") Integer var1);

    @PostMapping(value={"/api/system/datapermission/permission/{userId}"})
    public Response setUserDataPermission(@PathVariable(value="userId") Integer var1, @RequestBody List<UserDataPermission> var2);

    @GetMapping(value={"/api/menu/findCanSelectedMenuTree"})
    public Response<List<MenuTreeDto>> findCanSelectedMenuTree(@RequestParam(value="currentId") Integer var1, @RequestParam(value="systemCode", required=false) String var2);

    @PostMapping(value={"/api/wxCipher/apply"})
    public Response applyWxCipher(@RequestBody PlatformUserCipherDto var1);

    @GetMapping(value={"/api/wxCipher/search"})
    public PageTable<PlatformUserCipher> searchWxCipherList(@RequestParam(value="limit", defaultValue="20") int var1, @RequestParam(value="page", defaultValue="1") int var2, @RequestParam(value="systemCode", required=false) String var3, @RequestParam(value="mobile", required=false) String var4, @RequestParam(value="name", required=false) String var5, @RequestParam(value="status", required=false) String var6);

    @GetMapping(value={"/api/wxCipher/delete/{id}"})
    public Response removeWxCipher(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/wxCipher/getByMobile"})
    public Response<PlatformUserCipher> getWxCipherByMobile(@RequestParam(value="mobile", required=false) String var1, @RequestParam(value="systemCode", required=false) String var2);

    @GetMapping(value={"/api/wxCipher/getByOpenId"})
    public Response<PlatformUserCipher> getWxCipherByOpenId(@RequestParam(value="openId", required=false) String var1);

    @GetMapping(value={"/api/wxCipher/checkActivation"})
    public Response<Boolean> checkWxCipherActivation(@RequestParam(value="openId", required=false) String var1);

    @PostMapping(value={"/api/wxCipher/update"})
    public boolean updateWxCipher(@RequestBody PlatformUserCipher var1);

    @GetMapping(value={"/api/wechatOpenAdminUser/getByOpenId"})
    public Response<List<WechatOpenAdminUser>> getAdminUserByOpenId(@RequestParam(value="openId", required=false) String var1, @RequestParam(value="type", required=false) String var2, @RequestParam(value="systemCode", required=false) String var3);

    @GetMapping(value={"/api/wechatOpenAdminUser/getByAcctName"})
    public Response<WechatOpenAdminUser> getAdminUserByAcctName(@RequestParam(value="acctName", required=false) String var1, @RequestParam(value="systemCode", required=false) String var2);

    @GetMapping(value={"/api/wechatOpenAdminUser/deleteByOpenId"})
    public Response<Boolean> deleteAdminUserByOpenId(@RequestParam(value="openId", required=false) String var1);

    @GetMapping(value={"/api/wechatOpenAdminUser/deleteByAcctName"})
    public Response<Boolean> deleteAdminUserByAcctName(@RequestParam(value="acctName", required=false) String var1, @RequestParam(value="systemCode", required=false) String var2);

    @PostMapping(value={"/api/wechatOpenAdminUser/insert"})
    public Response<Boolean> insertAdminUser(@RequestBody WechatOpenAdminUser var1);

    @PostMapping(value={"/api/wechatOpenLoginLog/insert"})
    public Response<Boolean> insertWechatOpenLoginLog(@RequestBody WechatOpenLoginLog var1);

    @PostMapping(value={"/api/wechatOpenUserInfo/saveOrUpdateUser"})
    public Response<Boolean> saveOrUpdateUserinfo(@RequestBody WechatOpenUserinfo var1);

    @GetMapping(value={"/api/wechatOpenUserInfo/getByOpenId"})
    public Response<WechatOpenUserinfo> getUserInfoByOpenId(@RequestParam(value="openId", required=false) String var1);

    @GetMapping(value={"/api/wechatOpenUserInfo/getByToken"})
    public Response<WechatOpenUserinfo> getUserInfoByToken(@RequestParam(value="token", required=false) String var1);

    @GetMapping(value={"/api/system/role/role/{id}/{roleType}"})
    public Response<List<Role>> getRolesByUserIdAndRoleType(@PathVariable(value="id") Long var1, @PathVariable(value="roleType") String var2, @RequestParam(value="systemCode", required=false) String var3);

    @PostMapping(value={"/api/system/users/role/{id}/{roleType}"})
    public Response setAdminUserRolesByIdAndRoleType(@PathVariable(value="id") Long var1, @RequestParam(value="roleIds") long[] var2, @PathVariable(value="roleType") String var3);

    @GetMapping(value={"/api/system/users/register"})
    public Response register(@RequestParam(value="mobile") String var1, @RequestParam(value="systemCode", required=false) String var2);

    @GetMapping(value={"/api/system/users/unRegister"})
    public Response unRegister(@RequestParam(value="mobile") String var1, @RequestParam(value="systemCode", required=false) String var2);

    @PostMapping(value={"/api/system/app/config/queryPage"})
    public PageTable<BasicWxMiniAppConfig> appConfigPageTable(@RequestBody BasicWxMiniAppConfig var1);

    @PostMapping(value={"/api/system/app/config/saveOrUpdate"})
    public Response appConfigSaveOrUpdate(@RequestBody BasicWxMiniAppConfig var1);

    @GetMapping(value={"/api/system/app/config/gainByMiniAppid/{miniAppid}"})
    public Response<BasicWxMiniAppConfig> gainByMiniAppid(@PathVariable(value="miniAppid") String var1);

    @GetMapping(value={"/api/system/app/config/listAppidAndName"})
    public List<BasicWxMiniAppConfig> listAppidAndName(@RequestParam(value="miniAppidList", required=false) List<String> var1);

    @GetMapping(value={"/api/system/app/config/getDataPNeedMiniAppConfigList"})
    public Response<List<BasicWxMiniAppConfig>> getDataPNeedMiniAppConfigList();

    @PostMapping(value={"/api/basic/mch/config/queryPage"})
    public PageTable<BasicWxPaymentMchConfig> mchConfigPageTable(@RequestBody BasicWxPaymentMchConfig var1);

    @PostMapping(value={"/api/basic/mch/config/saveOrUpdate"})
    public Response mchConfigSaveOrUpdate(@RequestBody BasicWxPaymentMchConfig var1);

    @GetMapping(value={"/api/basic/mch/config/gainByMchId/{mchId}"})
    public Response<BasicWxPaymentMchConfig> gainByMchId(@PathVariable(value="mchId") String var1);
}

