package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 微信号激活绑定关系
 * </p>
 *
 * @author djt
 * @since 2021-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("basic_wechat_activate_record")
public class WechatActivateRecord implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 激活姓名
     */
    private String name;

    /**
     * 激活微信昵称
     */
    private String nickname;

    /**
     * 激活微信openID
     */
    private String openId;

    /**
     * 手机
     */
    private String mobile;

    /**
     * 微信openID绑定该账号情况 0 已绑定 1 未绑定
     */
    private Integer status;

    /**
     * 所属项目
     */
    private String systemCode;

    /**
     * 绑定时间
     */
    private LocalDateTime bindTime;


}
