package com.rocogz.syy.infrastructure.entity.role;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 车服后台管理系统角色信息
 * @author djt
 * @date 2021/1/13
 */
@Data
@TableName("basic_admin_role_info")
public class AdminRoleInfo implements Serializable {


    private Integer roleId;


    /**
     * 平台角色权限可以平台范围 ALL所有平台 SPECIFIC 特定的
     */
    private String platformScope;


    /**
     * 平台角色所属平台编号
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String platformCode;

    /**
     * 平台角色所属平台名称
     */
    @TableField(exist = false)
    private String platformName;



    /**
     * @since 20210207 平台角色改为发放主体角色
     * 发放主体角色权限范围 ALL所有发放主体 SPECIFIC 特定的
     */
    private String issuingBodyScope;

    /**
     * @since 20210207 平台角色改为发放主体角色
     * 发放主体角色关联的发放主体编号
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String issuingBodyCodes;

    /**
     * 发放主体角色关联的发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyNames;
}
