package com.rocogz.syy.infrastructure.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.infrastructure.dto.datapermission.miniAppPerfecture.DPMiniAppPrefectureTreeDto;
import com.rocogz.syy.infrastructure.dto.datapermission.team.DPTeamTreeDto;
import com.rocogz.syy.infrastructure.dto.log.ApiRequestLogStatisticsResponseDto;
import com.rocogz.syy.infrastructure.dto.login.PlatformUserCipherDto;
import com.rocogz.syy.infrastructure.dto.manager.*;
import com.rocogz.syy.infrastructure.dto.sms.SmsParamDto;
import com.rocogz.syy.infrastructure.dto.sms.SmsWithTemplateParamDto;
import com.rocogz.syy.infrastructure.dto.system.SetPermissionDto;
import com.rocogz.syy.infrastructure.dto.system.adminuser.*;
import com.rocogz.syy.infrastructure.dto.system.role.RoleSearchReq;
import com.rocogz.syy.infrastructure.dto.systemRun.BasicSystemRunManageReq;
import com.rocogz.syy.infrastructure.dto.systemRun.BasicSystemRunManageRes;
import com.rocogz.syy.infrastructure.dto.team.*;
import com.rocogz.syy.infrastructure.dto.tree.CustomMenuTreeDto;
import com.rocogz.syy.infrastructure.dto.tree.MenuTreeDto;
import com.rocogz.syy.infrastructure.dto.tree.PrefectureTreeDto;
import com.rocogz.syy.infrastructure.dto.userLog.UserLogListResp;
import com.rocogz.syy.infrastructure.dto.userLog.UserLogPageReq;
import com.rocogz.syy.infrastructure.dto.userLog.UserLogSaveReq;
import com.rocogz.syy.infrastructure.dto.weixin.SendSubscribeMesDto;
import com.rocogz.syy.infrastructure.dto.weixin.WeixinSubscribeMessageDto;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUserInfo;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUserRealNameAuthentication;
import com.rocogz.syy.infrastructure.entity.adminuser.WechatActivateRecord;
import com.rocogz.syy.infrastructure.entity.apiInfomation.ApiInformation;
import com.rocogz.syy.infrastructure.entity.app.config.BasicWxMiniAppConfig;
import com.rocogz.syy.infrastructure.entity.area.entity.ProvCityArea;
import com.rocogz.syy.infrastructure.entity.dict.DictData;
import com.rocogz.syy.infrastructure.entity.dict.DictLicensePrefix;
import com.rocogz.syy.infrastructure.entity.dict.DictType;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatform;
import com.rocogz.syy.infrastructure.entity.dockingPlatform.DockingPlatformIpAddr;
import com.rocogz.syy.infrastructure.entity.issuingbodyrole.BasicIssuingBodyRole;
import com.rocogz.syy.infrastructure.entity.log.*;
import com.rocogz.syy.infrastructure.entity.manager.RocoManager;
import com.rocogz.syy.infrastructure.entity.mchConfig.BasicWxPaymentMchConfig;
import com.rocogz.syy.infrastructure.entity.menu.CustomMenu;
import com.rocogz.syy.infrastructure.entity.menu.Menu;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.entity.platformcipher.PlatformUserCipher;
import com.rocogz.syy.infrastructure.entity.prefecture.Prefecture;
import com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea;
import com.rocogz.syy.infrastructure.entity.role.Role;
import com.rocogz.syy.infrastructure.entity.subscription.entity.BasicWxSubscription;
import com.rocogz.syy.infrastructure.entity.systemRun.BasicSystemRunManage;
import com.rocogz.syy.infrastructure.entity.systemRun.BasicSystemRunManageLog;
import com.rocogz.syy.infrastructure.entity.team.BasicTeamInfo;
import com.rocogz.syy.infrastructure.entity.team.BasicTeamUserInfo;
import com.rocogz.syy.infrastructure.entity.team.BasicTeamUserSelectBoxInfo;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenAdminUser;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenLoginLog;
import com.rocogz.syy.infrastructure.entity.wechat.WechatOpenUserinfo;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: IInfrastructureClientService</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/10 10:48</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public interface IInfrastructureClientService {

    /*********************************************   ranxiangfu 发送短信相关 Start   ********************************************************************/
    /**
     * 发送短信验证码.
     *
     * @param smsParamDto the sms param dto
     * @return the response
     */
    @PostMapping("/api/basic/sms/send")
    Response<String> sendShortMsg(@RequestBody SmsParamDto smsParamDto);

    /**
     * 发送短信, 需要传入具体的阿里云模板编号和模板参数.
     *
     * @param paramDto the param dto
     * @return the response
     */
    @PostMapping("/api/basic/sms/sendByTemplateCode")
    Response<String> sendByTemplateCode(@RequestBody SmsWithTemplateParamDto paramDto);

    /*********************************************   ranxiangfu 发送短信相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 省份-城市-区域相关 Start   ****************************************************************/

    /**
     * 根据父级编码获取所有下级区域.
     *
     * @param pcode 父级编码
     * @return the children by pcode
     */
    @GetMapping("/api/basic/prov-city-area/getChildrenByPcode")
    Response<List<ProvCityArea>> getProvCityAreaListByPcode(@RequestParam("pcode") String pcode);

    /**
     * 根据父级编码获取所有下级区域. ( like PCode%)
     *
     * @param pcode 父级编码
     * @return the children by pcode
     */
    @GetMapping("/api/basic/prov-city-area/getChildrenByPcodeWithLike")
    Response<List<ProvCityArea>> getChildrenByPcodeWithLike(@RequestParam("pcode") String pcode);
    /*********************************************   ranxiangfu 省份-城市-区域相关 end   ********************************************************************/

    /*********************************************  yinshihao 字典值相关 Start   ****************************************************************/
    /**
     * 字典值列表 不需要分页
     *
     * @param pCode    父常量ID
     * @param typeCode 类型编码
     * @param status   the status
     * @param code     the code
     * @param keyword  the keyword
     * @return response response
     */
    @GetMapping("/api/dict/data")
    Response<List<DictData>> searchDictData(@RequestParam(value = "pCode", required = false) String pCode,
                                            @RequestParam(value = "typeCode", required = false) String typeCode,
                                            @RequestParam(value = "status", required = false) String status,
                                            @RequestParam(value = "code", required = false) String code,
                                            @RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 根据id查询字典值信息
     *
     * @param id id
     * @return dict data
     */
    @GetMapping("/api/dict/data/{id}")
    Response<DictData> getDictData(@PathVariable("id") Long id);

    /**
     * 字典类型状态改变
     *
     * @param id     用户id
     * @param status 改变后的状态
     * @return response response
     */
    @PostMapping("/api/dict/data/status/{id}")
    Response switchDictDataStatus(@PathVariable("id") Long id, @RequestParam("status") String status);

    /**
     * Batch edit dict data response.
     *
     * @param dictDatas the dict datas
     * @return the response
     */
    @PostMapping("/api/dict/data/batchEdit")
    Response batchEditDictData(@RequestBody List<DictData> dictDatas);

    /**
     * 根据类型编码获取字典数据
     *
     * @param typeCode the type code
     * @return dict data by type code
     */
    @GetMapping("/api/dict/data/get/{typeCode}")
    Response<List<DictData>> getDictDataByTypeCode(@PathVariable("typeCode") String typeCode);

    /**
     * 根据类型编码和状态获取字典数据
     *
     * @return
     */
    @GetMapping("/api/dict/data/getDictDataByTypeCodeAndStatus/{typeCode}")
    Response<List<DictData>> getDictDataByTypeCodeAndStatus(@PathVariable("typeCode") String typeCode, @RequestParam("status") String status);

    /**
     * 根据多种类型编码获取对应的字典数据
     *
     * @param typeCodeList 字典类型集合
     * @return dict data by type code list
     */
    @GetMapping("/api/dict/data/getDataByTypeCodeList")
    Response<Map<String, List<DictData>>> getDictDataByTypeCodeList(@RequestParam("typeCodeList") List<String> typeCodeList);

    /**
     * 根据类型编码和数据编码获取字典数据
     *
     * @param typeCode 类型编码
     * @param code     数据编码
     * @return
     */
    @GetMapping("/api/dict/data/getDictDataByTypeCodeAndCode")
    Response<DictData> getDictDataByTypeCodeAndCode(@RequestParam("typeCode") String typeCode,
                                                    @RequestParam("code") String code);

    /**
     * 根据类型编码和数据name获取字典数据
     *
     * @param typeCode 类型编码
     * @param name     数据name
     * @return
     */
    @GetMapping("/api/dict/data/getDictDataByTypeCodeAndName")
    Response<DictData> getDictDataByTypeCodeAndName(@RequestParam("typeCode") String typeCode,
                                                    @RequestParam("name") String name);

    /**
     * 获取字典类型列表
     *
     * @param keyword 查询关键字
     * @param page    页码
     * @param limit   每页条数
     * @return
     */
    @GetMapping("/api/dict/data/seachPageByTypeCode")
    PageTable<DictData> seachPageByTypeCode(@RequestParam(value = "typeCode", required = false) String typeCode,
                                            @RequestParam(value = "status", required = false) String status,
                                            @RequestParam(value = "code", required = false) String code,
                                            @RequestParam(value = "codes", required = false) List<String> codes,
                                            @RequestParam(value = "keyword", required = false) String keyword,
                                            @RequestParam(value = "limit", defaultValue = "20") int limit,
                                            @RequestParam(value = "page", defaultValue = "1") int page);
    /*********************************************   yinshihao 字典值相关 end   ********************************************************************/

    /*********************************************  yinshihao 字典类型相关 Start   ****************************************************************/

    /**
     * 字典类型列表
     *
     * @param keyword 查询关键字
     * @param limit   每页条数
     * @param page    页码
     * @return page table
     */
    @GetMapping("/api/dict/type")
    PageTable<DictType> searchDictType(@RequestParam(value = "keyword", required = false) String keyword,
                                       @RequestParam(value = "limit", defaultValue = "20") int limit,
                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据id查询字典值信息
     *
     * @param id id
     * @return dict type
     */
    @GetMapping("/api/dict/type/{id}")
    Response<DictType> getDictType(@PathVariable("id") Long id);

    /**
     * 字典类型状态改变
     *
     * @param id     用户id
     * @param status 改变后的状态
     * @return response response
     */
    @PostMapping("/api/dict/type/status/{id}")
    Response switchDictTypeStatus(@PathVariable("id") Long id, @RequestParam("status") String status);

    /**
     * 添加或编辑字典类型
     *
     * @param type 字典类型
     * @return response response
     */
    @PostMapping("/api/dict/type")
    Response saveOrUpdateDictType(DictType type);

    /**
     * 根据类型编码列表和状态获取字典类型及数据
     *
     * @return
     */
    @GetMapping("/api/dict/type/getDictTypeByTypeCodes")
    Response<List<DictType>> getDictDataByTypeCodeAndStatus(@RequestParam("typeCodes") List<String> typeCodes, @RequestParam(value = "dataStatus", required = false) String dataStatus);
    /*********************************************   yinshihao 字典类型相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 专区区域相关 Start   ****************************************************************/

    /**
     * 根据专区编码获取区域列表.
     *
     * @param prefectureCode 专区编码
     * @return the response
     */
    @GetMapping("/api/basic/prefectureArea/listByPrefectureCode")
    Response<List<PrefectureArea>> listPrefectureAreaByPrefectureCode(@RequestParam("prefectureCode") String prefectureCode);

    /**
     * Query prefecture area by entity response.
     *
     * @param prefectureArea the prefecture area
     * @return the response
     */
    @PostMapping("/api/basic/prefectureArea/queryByEntity")
    Response<PrefectureArea> queryPrefectureAreaByEntity(@RequestBody PrefectureArea prefectureArea);

    /**
     * 新增专区区域.
     *
     * @param prefectureArea 专区区域对象 {@link com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea}
     * @return the response
     */
    @PostMapping("/api/basic/prefectureArea")
    Response addPrefectureArea(@RequestBody PrefectureArea prefectureArea);

    /**
     * 批量新增专区区域.
     *
     * @param prefectureAreaList 专区区域对象列表 {@link com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea}
     * @return the response
     */
    @PostMapping("/api/basic/prefectureArea/saveBatch")
    Response saveBatchPrefectureArea(@RequestBody List<PrefectureArea> prefectureAreaList);

    /**
     * 根据id删除专区区域.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/basic/prefectureArea")
    Response removePrefectureArea(@RequestParam("id") Integer id);

    /*********************************************   ranxiangfu 专区区域相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 专区相关 Start   ****************************************************************/

    /**
     * 根据专区编码获取子专区.
     *
     * @param prefectureCode 专区编码
     * @return the child
     */
    @GetMapping("/api/basic/prefecture/getChild")
    Response<List<Prefecture>> getPrefectureChild(@RequestParam("prefectureCode") String prefectureCode);

    /**
     * 分页查询专区. 带专区限制
     *
     * @param code          专区编码
     * @param name          专区名称
     * @param status        专区状态
     * @param inCodes       权限专区
     * @param miniAppidList 小程序appid列表
     * @param page          the page
     * @param limit         the limit
     * @return page table
     */
    @GetMapping("/api/basic/prefecture/pageQuery")
    PageTable<Prefecture> pageQueryPrefecture(@RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "status", required = false) String status,
                                              @RequestParam(value = "inCodes", required = false) List<String> inCodes,
                                              @RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList,
                                              @RequestParam(value = "page", defaultValue = "1") Integer page,
                                              @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 获取专区树列表.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/basic/prefecture/getTree")
    Response<List<PrefectureTreeDto>> getPrefectureTree(
            @RequestParam(value = "inCodes", required = false) List<String> inCodes,
            @RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList);

    /**
     * 根据id查询专区.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/basic/prefecture/{id}")
    Response<Prefecture> getPrefectureById(@PathVariable("id") Integer id);

    /**
     * 根据编码查询专区.
     *
     * @param code 专区编码
     * @return the by id
     */
    @GetMapping("/api/basic/prefecture/getByCode")
    Response<Prefecture> getPrefectureByCode(@RequestParam("code") String code);

    /**
     * 新增或者更新专区信息(对象的id属性为空时代表新增).
     *
     * @param prefecture 专区对象 {@link com.rocogz.syy.infrastructure.entity.prefecture.Prefecture}
     * @return the response
     */
    @PostMapping("/api/basic/prefecture")
    Response saveOrUpdatePrefecture(@RequestBody Prefecture prefecture);

    /**
     * 查询所有专区
     *
     * @param status            专区状态
     * @param openServiceStatus 专区服务开通状态
     * @return response response
     */
    @GetMapping("/api/basic/prefecture/findPrefectureList")
    Response<List<Prefecture>> findPrefectureList(@RequestParam(value = "status", required = false) String status,
                                                  @RequestParam(value = "openServiceStatus", required = false) String openServiceStatus,
                                                  @RequestParam(value = "miniAppid", required = false) String miniAppid,
                                                  @RequestParam(value = "inCodes", required = false) List<String> inCodes,
                                                  @RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList);

    /**
     * 根据专区编码查询所有专区
     *
     * @param code               the code
     * @param name               the name
     * @param prefectureCodeList 专区编码列表
     * @return response response
     */
    @GetMapping("/api/basic/prefecture/findPrefectureByCode")
    Response<List<Prefecture>> findPrefectureListByCode(@RequestParam(value = "code", required = false) String code,
                                                        @RequestParam(value = "name", required = false) String name,
                                                        @RequestParam("prefectureCodeList") List<String> prefectureCodeList);

    /**
     * 根据区域查询一个可用的专区.
     *
     * @param prefectureArea 专区区域对象 {@link com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea}
     * @return the one available prefecture by area
     */
    @PostMapping("/api/basic/prefecture/getOneAvailablePrefectureByArea")
    Response<Prefecture> getOneAvailablePrefectureByArea(@RequestBody PrefectureArea prefectureArea, @RequestParam(value = "miniAppid", required = false) String miniAppid);

    /**
     * 根据区域查询可用的专区列表.
     *
     * @param prefectureArea 专区区域对象 {@link com.rocogz.syy.infrastructure.entity.prefecture.PrefectureArea}
     * @return the one available prefecture by area
     */
    @PostMapping("/api/basic/prefecture/listAvailablePrefectureByArea")
    Response<List<Prefecture>> listAvailablePrefectureByArea(@RequestBody PrefectureArea prefectureArea, @RequestParam(value = "miniAppid", required = false) String miniAppid);
    /*********************************************   ranxiangfu 专区相关 end   ********************************************************************/

    /*********************************************  yinshihao 对接平台相关 Start   ****************************************************************/

    /**
     * 对接平台列表
     *
     * @param keyword 对接平台名称或编码
     * @param status  标签状态
     * @param limit   每页条数
     * @param page    页码
     * @return page table
     */
    @GetMapping("/api/basic/dockingPlatform")
    PageTable<DockingPlatform> findDockingPlatformList(@RequestParam(value = "keyword", required = false) String keyword,
                                                       @RequestParam(value = "status", required = false) String status,
                                                       @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 对接平台状态改变
     *
     * @param dockingPlatform the docking platform
     * @return response response
     */
    @PostMapping("/api/basic/dockingPlatform/changeDockingPlatformstatus")
    Response changeDockingPlatformstatus(@RequestBody DockingPlatform dockingPlatform);

    /**
     * 根据id查询对接平台信息
     *
     * @param id 对接平台id
     * @return docking platform by id
     */
    @GetMapping("/api/basic/dockingPlatform/{id}")
    Response<DockingPlatform> getDockingPlatformById(@PathVariable("id") Integer id);

    /**
     * 根据code查询对接平台信息
     *
     * @param code   对接平台code
     * @param status 对接平台状态
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/getDockingPlatformByCode")
    Response<DockingPlatform> getDockingPlatformByCode(@RequestParam("code") String code, @RequestParam(value = "status", required = false) String status);

    /**
     * 创建或更新对接平台
     *
     * @param dockingPlatform the docking platform
     * @return response response
     */
    @PostMapping("/api/basic/dockingPlatform/saveOrUpdateDockingPlatform")
    Response saveOrUpdateDockingPlatform(@RequestBody DockingPlatform dockingPlatform);

    /**
     * 获取对接平台列表(不返回key和iv)
     *
     * @param provideCoupon 是否发放优惠券
     * @param status        状态
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/findDockingPlatformListNoKeyAndIv")
    Response<List<DockingPlatform>> findDockingPlatformListNoKeyAndIv(@RequestParam(value = "provideCoupon", required = false) String provideCoupon,
                                                                      @RequestParam(value = "status", required = false) String status);

    /**
     * 根据平台编码获取对接平台信息(不返回key和iv)
     *
     * @param code 平台编码
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/getDockingPlatformByCodeNoKeyAndIv")
    Response<DockingPlatform> getDockingPlatformByCodeNoKeyAndIv(@RequestParam("code") String code);

    /**
     * 根据平台编码集合获取对应的对接平台信息(不返回key和iv)
     *
     * @param codeList 平台编码集合
     * @return
     */
    @GetMapping("/api/basic/dockingPlatform/getDockingPlatformListByCodeListNoKeyAndIv")
    Response<List<DockingPlatform>> getDockingPlatformListByCodeListNoKeyAndIv(@RequestParam("codeList") List<String> codeList);

    /*********************************************   yinshihao 对接平台相关 end   ********************************************************************/

    /*********************************************  yinshihao 接口权限相关 Start   ****************************************************************/

    /**
     * 查询接口权限列表
     *
     * @param platformCode 平台编码
     * @param serviceName  服务名
     * @param name         接口名
     * @param limit        the limit
     * @param page         the page
     * @return page table
     */
    @GetMapping("/api/basic/apiInfomation/queryApi")
    PageTable<ApiInformation> queryApi(@RequestParam(value = "platformCode", required = false) String platformCode,
                                       @RequestParam(value = "serviceName", required = false) String serviceName,
                                       @RequestParam(value = "name", required = false) String name,
                                       @RequestParam(value = "limit", defaultValue = "20") int limit,
                                       @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 查询接口权限列表
     *
     * @param serviceName 服务名
     * @param name        接口名
     * @return
     */
    @GetMapping("/api/basic/apiInfomation/findApiInformationList")
    PageTable<ApiInformation> findApiInformationList(@RequestParam(value = "serviceName", required = false) String serviceName,
                                                     @RequestParam(value = "name", required = false) String name,
                                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                     @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 无查询条件下查询接口权限列表
     *
     * @param limit the limit
     * @param page  the page
     * @return page table
     */
    @GetMapping("/api/basic/apiInfomation/queryApiList")
    PageTable<ApiInformation> queryApiList(@RequestParam(value = "limit", defaultValue = "20") int limit,
                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据平台编码删除对应接口信息
     *
     * @param platformCode the platform code
     * @param apiId        the api id
     * @return response response
     */
    @GetMapping("/api/basic/apiInfomation/deleteApiByPlatformCode")
    Response deleteApiByPlatformCode(@RequestParam(value = "platformCode") String platformCode,
                                     @RequestParam(value = "apiId") Integer apiId);

    /**
     * 根据平台编码获取其对应的接口列表
     *
     * @param platformCode the platform code
     * @return api list by platform code
     */
    @GetMapping("/api/basic/apiInfomation/getApiListByPlatformCode")
    Response<List<ApiInformation>> getApiListByPlatformCode(@RequestParam(value = "platformCode") String platformCode);

    /**
     * 根据平台编码获取其对应的接口列表
     *
     * @param platformCode the platform code
     * @param status       the status
     * @return api list by platform code
     */
    @GetMapping("/api/basic/apiInfomation/getApiListByPlatformCodeAndStatus")
    Response<List<ApiInformation>> getApiListByPlatformCodeAndStatus(@RequestParam(value = "platformCode") String platformCode, @RequestParam(value = "status") String status);

    /**
     * 修改平台的接口状态
     *
     * @param apiId        接口id
     * @param status       该平台下该接口的状态
     * @param platformCode 平台编码
     * @param updateUser   操作用户
     * @return response response
     */
    @PostMapping("/api/basic/apiInfomation/changePlatformApiStatusById/{apiId}")
    Response changePlatformApiStatusById(@PathVariable("apiId") Integer apiId,
                                         @RequestParam("status") String status,
                                         @RequestParam("platformCode") String platformCode,
                                         @RequestParam("updateUser") String updateUser);

    /**
     * 根据平台编码添加其对应的接口
     *
     * @param apiIdList    添加的接口列表
     * @param platformCode 平台编码
     * @param updateUser   操作用户
     * @return response response
     */
    @PostMapping("/api/basic/apiInfomation/addApiListByPlatformCode")
    Response addApiListByPlatformCode(@RequestParam("apiIdList") List<Integer> apiIdList,
                                      @RequestParam("platformCode") String platformCode,
                                      @RequestParam("updateUser") String updateUser);

    /*********************************************   yinshihao 接口权限相关 end   ********************************************************************/

    /*********************************************  zhangmin 车牌号 前缀相关 Start   ****************************************************************/

    /**
     * 根据 省名称 / 城市名 通配符 获得车牌号前缀
     *
     * @param provName 省名称
     * @param cityName 城市名称
     * @return
     */
    @RequestMapping("/api/basic/dict/dictLicensePrefix")
    Response<DictLicensePrefix> getLicensePrefixByProvCityNameLike(@RequestParam("provName") String provName,
                                                                   @RequestParam("cityName") String cityName);

    /*********************************************   zhangmin 车牌号 前缀相关 end   ********************************************************************/

    /*********************************************  yinshihao 用户相关 Start   ****************************************************************/

    /**
     * 管理员用户列表
     *
     * @param searchDTO 账户名
     * @return
     */
    @GetMapping("/api/system/users")
    PageTable<AdminUser> findAdminUserList(@SpringQueryMap AdminUserSearchDTO searchDTO);

    /**
     * 查询用户所有菜单
     *
     * @return
     */
    @PostMapping("/api/system/users/findMenu")
    List<Menu> findMenuByAdminUserId(@RequestParam("userId") Integer userId);

    /**
     * 查询用户所有菜单
     *
     * @return
     */
    @PostMapping("/api/system/users/findCustomMenu")
    List<Menu> findCustomMenuByAdminUserIdAndType(@RequestParam("userId") Integer userId, @RequestParam("type") String type);


    /**
     * 查询用户所有菜单(不是树)
     *
     * @return
     */
    @GetMapping("/api/system/users/getCustomMenuByUserId")
    Response<List<Menu>> getCustomMenuByUserId(@RequestParam("userId") Integer userId);

    /**
     * 新建管理员用户
     *
     * @param req
     * @return
     */
    @PostMapping("/api/system/users")
    Response<AdminUser> createAdminUser(UserSaveReq req);

    /**
     * 更新管理员用户
     *
     * @param req
     * @return
     */
    @PostMapping("/api/system/users/edit")
    Response editAdminUser(UserSaveReq req);

    /**
     * 根据id查询用户信息
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/{id}")
    Response<AdminUser> getAdminUserById(@PathVariable("id") Long id);

    /**
     * 重置用户密码
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/{id}/password")
    Response resetAdminUserPwd(@PathVariable("id") Long id);

    /**
     * 根据用户id查询用户角色信息
     *
     * @param id         用户id
     * @param systemCode 所属项目编码
     * @return
     */
    @GetMapping("/api/system/users/role/{id}")
    Response<List<Role>> getAdminUserRolesById(@PathVariable("id") Long id, @RequestParam("systemCode") String systemCode);

    /**
     * 为用户设置角色信息
     *
     * @param id      用户id
     * @param roleIds 角色ids
     * @return
     */
    @PostMapping("/api/system/users/role/{id}")
    Response setAdminUserRolesById(@PathVariable("id") Long id, @RequestParam("roleIds") long[] roleIds);


    /**
     * 根据角色类型查询角色
     *
     * @param type
     * @param types
     * @param systemCode
     * @return
     */
    @GetMapping("/api/system/role/listAllRoleByType")
    Response<List<Role>> listAllRoleByType(@RequestParam(value = "type", required = false) String type,
                                           @RequestParam(value = "types", required = false) String types,
                                           @RequestParam("systemCode") String systemCode);

    /**
     * 用户状态改变
     *
     * @param id     用户id
     * @param status 改变后的状态
     * @return
     */
    @PostMapping("/api/system/users/status/{id}")
    Response switchAdminUserStatus(@PathVariable("id") Long id, @RequestParam("status") String status);

    /**
     * 根据id删除用户（逻辑删除）
     *
     * @param id 用户id
     * @return
     */
    @GetMapping("/api/system/users/delete/{id}")
    Response deleteAdminUserById(@PathVariable("id") Long id);

    /**
     * 修改用户密码
     *
     * @param oldPwd     原密码
     * @param newPwd     新密码
     * @param confirmPwd 确认密码
     * @param userId     用户Id
     * @return
     */
    @PostMapping(value = "/api/system/users/password/modify")
    Response updateAdminUserPwd(@RequestParam("oldPwd") String oldPwd, @RequestParam("newPwd") String newPwd, @RequestParam("confirmPwd") String confirmPwd, @RequestParam("userId") Integer userId);

    /**
     * 修改用户密码,不检验旧密码
     *
     * @param newPwd 新密码
     * @param userId 用户id
     * @return response response
     */
    @PostMapping(value = "/api/system/users/password/modifyNoCheckOld")
    Response updateAdminUserPwdNoCheckOld(@RequestParam("newPwd") String newPwd, @RequestParam("userId") Integer userId);

    /**
     * 批量启用用户
     *
     * @param idList
     * @return
     */
    @RequestMapping("/api/system/users/batch/open")
    Response batchOpenAdminUser(@RequestBody List<Long> idList);

    /**
     * 批量停用用户
     *
     * @param idList
     * @return
     */
    @RequestMapping("/api/system/users/batch/lock")
    Response batchLockAdminUser(@RequestBody List<Long> idList);

    /**
     * 批量重置密码
     *
     * @param idList
     * @return
     */
    @RequestMapping("/api/system/users/batch/resetpwd")
    Response resetAdminUserPwd(@RequestBody List<Long> idList);

    /**
     * @param id
     * @return
     */
    @PostMapping("/api/system/users/getAllInfoById")
    AdminUser getAdminUserAllInfoById(@RequestParam("id") Integer id);

    /**
     * 根据用户名查询用户的所有信息（角色、权限）
     *
     * @param username   用户名
     * @param systemCode 所属项目
     * @param type       类型
     * @return
     */
    @PostMapping("/api/system/users/getAllInfoByUsername")
    AdminUser getAdminUserAllInfoByUsername(@RequestParam("username") String username,
                                            @RequestParam(value = "systemCode", required = false) String systemCode,
                                            @RequestParam(value = "type") String type);

    /**
     * 根据用户名查询用户的所有信息（角色、权限）
     *
     * @param identity   用户名/手机号
     * @param type       类型
     * @param systemCode 所属项目
     * @return
     */
    @PostMapping("/api/system/users/getAllInfoByIdentity")
    AdminUser getAdminUserAllInfoByIdentity(@RequestParam("identity") String identity,
                                            @RequestParam(value = "type") String type,
                                            @RequestParam(value = "systemCode") String systemCode);

    /**
     * 激活用户
     *
     * @param id       用户id
     * @param password 用户密码
     * @return
     */
    @PostMapping("/api/system/users/active")
    Response activeAdminUser(@RequestParam("id") Long id, @RequestParam("password") String password);

    /**
     * 根据用户名列表查询 用户名称列表
     *
     * @param systemCode 所属项目
     * @param usernames
     * @return
     */
    @PostMapping("/api/system/users/names")
    Response<List<AdminUser>> queryAccountListByUsenames(@RequestParam(value = "systemCode", required = false) String systemCode,
                                                         @RequestBody List<String> usernames);

    /**
     * 根据角色id查询对应的用户列表
     *
     * @param roleId 角色id
     * @return
     */
    @GetMapping("/api/system/users/getUserListByRoleId/{roleId}")
    Response<List<AdminUser>> getUserListByRoleId(@PathVariable("roleId") Integer roleId);

    /**
     * 根据手机号码查询对应的用户列表
     *
     * @param mobile
     * @param systemCode 所属项目
     * @return
     */
    @GetMapping("/api/system/users/getByMobile")
    Response<List<AdminUser>> getUserByMobile(@RequestParam("mobile") String mobile, @RequestParam(value = "systemCode", required = false) String systemCode);


    /**
     * 根据账号查询账号详情
     *
     * @param username
     * @param systemCode
     * @return
     */
    @GetMapping("/api/system/users/detail")
    Response<AdminUserDetailVO> detailAdminUser(@RequestParam("username") String username, @RequestParam("systemCode") String systemCode);


    /**
     * 根据账号名查找账号微信激活详情
     *
     * @param userId 用户id
     * @return
     */
    @GetMapping("/api/system/users/activateInfo")
    Response activateInfo(@RequestParam("userId") Integer userId);


    /**
     * 解除手机号绑定微信
     *
     * @param mobile     用户名
     * @param systemCode 所属项目
     * @return
     */
    @GetMapping("/api/system/users/unboundWechat")
    Response unboundWechat(@RequestParam("mobile") String mobile, @RequestParam("systemCode") String systemCode);


    /**
     * 保存微信激活记录
     *
     * @param wechatActivateRecord
     * @return
     */
    @PostMapping("/api/system/users/boundActivateRecord")
    Response boundActivateRecord(@RequestBody WechatActivateRecord wechatActivateRecord);


    /**
     * 查找所有的账号用于导出
     *
     * @param searchDTO
     * @return
     */
    @GetMapping("/api/system/users/findAllForExport")
    Response<List<AdminUserExportDTO>> findAllAdminUserForExport(@SpringQueryMap AdminUserSearchDTO searchDTO);


    /**
     * 更改发放主体账号的是否可见领取信息
     *
     * @param visibleFlat     Y 可见 N不可见
     * @param issuingBodyCode 发放主体编号
     * @return
     */
    @GetMapping("/api/system/admin/issuingBodyUser/updateReceiveVisible")
    Response<Integer> updateReceiveVisible(@RequestParam("visibleFlat") String visibleFlat,
                                           @RequestParam("issuingBodyCode") String issuingBodyCode);

    /**
     * 根据用户名获取发放主体团队用户
     *
     * @param username
     * @return
     */
    @GetMapping("/api/system/admin/issuingBodyUser/issuingBodyTeamUser")
    Response<IssuingBodyTeamUserDTO> getIssuingBodyTeamUserByUsername(@RequestParam("username") String username);

    /**
     * 根据用户名获取发放主体用户
     *
     * @param username
     * @return
     */
    @GetMapping("/api/system/admin/issuingBodyUser/getIssuingBodyUserByUsername")
    Response<AdminUser> getIssuingBodyUserByUsername(@RequestParam("username") String username);


    /**
     * 根据用户名查询用户
     *
     * @param username
     * @param systemCode
     * @return
     */
    @GetMapping("/api/system/users/getAdminUserByUsername")
    Response<AdminUser> getAdminUserByUsername(@RequestParam("username") String username,
                                               @RequestParam("systemCode") String systemCode);


    /**
     * 新增服务商账号
     *
     * @param req
     * @return
     */
    @PostMapping("/api/basic/service/user/add")
    Response<AdminUser> createServiceUser(@RequestBody UserSaveReq req);

    /**
     * 编辑服务商账号
     *
     * @param req
     * @return
     */
    @PostMapping("/api/basic/service/user/edit")
    Response editServiceUser(@RequestBody UserSaveReq req);

    /**
     * 分页查询服务商账号(包括角色)
     *
     * @param req
     * @return
     */
    @PostMapping("/api/basic/service/user/")
    PageTable<AdminUser> pageServiceUser(@SpringQueryMap AdminServiceUserSearchReq req);

    /**
     * 分页查询服务商账号基本信息(不包括角色)
     *
     * @param req
     * @return
     */
    @PostMapping("/api/basic/service/user/pageBase")
    PageTable<AdminUser> pageBaseServiceUser(@SpringQueryMap AdminServiceUserSearchReq req);


    /*********************************************   yinshihao 用户相关 end   ********************************************************************/

    /*********************************************  yinshihao 用户角色相关 Start   ****************************************************************/

    /**
     * 角色列表
     *
     * @param req
     * @return
     */
    @GetMapping("/api/system/role")
    PageTable<Role> pageFindRoleList(@SpringQueryMap RoleSearchReq req);

    /**
     * 添加或编辑角色信息
     *
     * @param role 角色信息
     * @return
     */
    @PostMapping("/api/system/role")
    Response saveOrUpdateRole(Role role);

    /**
     * 根据id查询角色信息
     *
     * @param id 角色id
     * @return
     */
    @GetMapping(value = "/api/system/role/{id}")
    Response<Role> getRoleById(@PathVariable("id") Long id);

    /**
     * 删除角色
     *
     * @Param id
     */
    @GetMapping(value = "/api/system/role/delete/{id}")
    Response deleteRole(@PathVariable("id") Long id);

    /**
     * 查询角色绑定的权限及未绑定权限
     *
     * @param id   角色id
     * @param type 类型-自定义菜单时传(BIZ/PLATFORM)
     * @return
     */
    @GetMapping(value = "/api/system/role/permission/{id}")
    Response<List<SetPermissionDto>> findRolePermission(@PathVariable("id") Long id, @RequestParam(value = "type", required = false) String type);

    /**
     * 设置角色权限
     *
     * @param id             主键
     * @param permissionDtos 菜单权限和操作权限DTO
     * @return
     */
    @PostMapping(value = "/api/system/role/permission/{id}")
    Response setRolePermissions(@PathVariable("id") Long id, List<SetPermissionDto> permissionDtos);

    /**
     * 根据用户id查询用户角色信息
     *
     * @param id         用户id
     * @param systemCode 所属项目编码
     * @return
     */
    @GetMapping("/api/system/role/role/{id}")
    Response<List<Role>> getRolesByUserId(@PathVariable("id") Long id, @RequestParam("systemCode") String systemCode);

    /**
     * 为用户设置角色信息
     *
     * @param id      用户id
     * @param roleIds 角色ids
     * @return
     */
    @PostMapping("/api/system/role/role/{id}")
    Response setRolesByUserId(@PathVariable("id") Long id, @RequestParam("roles") long[] roleIds);

    /**
     * 获取所有角色信息
     *
     * @param req
     * @return
     */
    @GetMapping("/api/system/role/findRoleList")
    Response<List<Role>> findRoleList(@SpringQueryMap RoleSearchReq req);

    /**
     * 获取所有发放主体角色信息
     *
     * @param req 用户类型
     * @return
     */
    @GetMapping("/api/system/role/findIssuingBodyRoleList")
    Response<List<Role>> findIssuingBodyRoleList(@SpringQueryMap RoleSearchReq req);

    /*********************************************  yinshihao 用户角色相关 end   ****************************************************************/

    /*********************************************  yinshihao 菜单相关 Start   ****************************************************************/

    /**
     * 菜单列表
     *
     * @param pid        父菜单ID
     * @param systemCode 所属项目
     * @param page       页码
     * @param limit      每页条数
     * @return
     */
    @GetMapping("/api/menu")
    PageTable<Menu> findMenuList(@RequestParam("pid") Long pid,
                                 @RequestParam(value = "systemCode", required = false) String systemCode,
                                 @RequestParam(value = "limit", defaultValue = "20") int limit,
                                 @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 左侧菜单列表
     *
     * @param systemCode 所属项目
     * @return
     */
    @GetMapping("/api/menu/findMenuTree")
    Response<List<MenuTreeDto>> findMenuTree(@RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 菜单详情
     *
     * @param id
     * @return
     */
    @GetMapping("/api/menu/getById/{id}")
    Response<Menu> getMenuById(@PathVariable("id") Long id);

    /**
     * 编辑菜单
     *
     * @param menu
     * @return
     */
    @PostMapping("/api/menu")
    Response editMenu(Menu menu);

    /**
     * 获取所有的启用菜单
     *
     * @param systemCode 所属项目
     * @return
     */
    @GetMapping("/api/menu/findAllOpen")
    Response<List<Menu>> findAllOpenMenu(@RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 根据菜单id状态改变
     *
     * @param id     菜单id
     * @param status 改变后的状态
     * @return
     */
    @PostMapping("/api/menu/status/{id}")
    Response switchStatus(@PathVariable("id") Integer id, @RequestParam("status") String status);

    /*********************************************   yinshihao 菜单相关 end   ********************************************************************/

    /*********************************************  hsf 自定义菜单相关 Start   ****************************************************************/
    /**
     * 自定义菜单列表
     *
     * @return
     */
    @GetMapping("/api/custom/menu/findMenuTree")
    Response<List<CustomMenuTreeDto>> findCustomMenuTree(@RequestParam("type") String type,
                                                         @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 自定义菜单列表ztree形式
     *
     * @param type
     * @param flag
     * @return
     */
    @GetMapping("/api/custom/menu/findMenuZTree")
    Response<List<Menu>> findCustomMenuZTree(@RequestParam("type") String type, @RequestParam("flag") String flag,
                                             @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 自定义菜单更新
     *
     * @param menu
     * @return
     */
    @PostMapping("/api/custom/menu/update")
    Response updateCustomMenu(@RequestBody CustomMenu menu);

    /**
     * 自定义菜单详情
     *
     * @param id
     * @return
     */
    @GetMapping("/api/custom/menu/detail/{id}")
    Response<CustomMenu> customMenuDetail(@PathVariable("id") Integer id);

    /**
     * 自定义菜单分页
     *
     * @param pid
     * @param type
     * @param systemCode
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/custom/menu")
    PageTable<CustomMenu> customMenuSearchScrollPage(@RequestParam(value = "pid", required = false) Integer pid,
                                                     @RequestParam("type") String type,
                                                     @RequestParam(value = "systemCode", required = false) String systemCode,
                                                     @RequestParam("limit") int limit,
                                                     @RequestParam("page") int page);

    /**
     * 自定义菜单更新状态
     *
     * @param customMenu
     * @return
     */
    @PostMapping("/api/custom/menu/updateStatus")
    Response customMenuUpdateStatus(@RequestBody CustomMenu customMenu);

    /**
     * 自定义菜单删除
     *
     * @param id
     * @return
     */
    @GetMapping("/api/custom/menu/delete/{id}")
    Response customMenuDelete(@PathVariable("id") Integer id);

    /*********************************************  hsf 自定义菜单相关 End   ****************************************************************/

    /*********************************************   liangyongtong 小程序订阅消息 start   ********************************************************************/
    /**
     * 发送订阅消息
     *
     * @param message 消息对象
     * @return
     */
    @PostMapping("/api/weixin/message/send")
    Response sendSubcribeMsg(@RequestBody WeixinSubscribeMessageDto message);

    /**
     * 发送订阅消息并删除订单关系
     *
     * @param message
     */
    @PostMapping("/api/weixin/message/sendAndDelete")
    Response sendSubcribeMsgAndDelete(@RequestBody SendSubscribeMesDto message);

    /**
     * 通过模板id 和 openid 获取对象
     *
     * @param templateId
     * @param openid
     * @return
     */
    @GetMapping("/api/weixin/message/subscription/queryInfo")
    Response<BasicWxSubscription> getInfoByTemplateIdAndOpenId(@RequestParam(required = false, value = "templateId") String templateId, @RequestParam(value = "openid", required = false) String openid, @RequestParam(value = "businessCode", required = false) String businessCode);

    /**
     * 保存对象
     *
     * @param subscription
     */
    @PostMapping("/api/weixin/message/subscription/saveInfo")
    Response saveSubscriptionInfo(@RequestBody BasicWxSubscription subscription);

    /**
     * 删除对象通过 模板id  和 openid
     *
     * @param templateId
     * @param openid
     */
    @GetMapping("/api/weixin/message/subscription/delete")
    Response deleteByTemplateIdAndOpenId(@RequestParam(required = false, value = "templateId") String templateId, @RequestParam(value = "openid") String openid, @RequestParam(value = "businessCode", required = false) String businessCode);

    /**
     * 通过业务编码列表删除
     *
     * @param businessCodes
     * @return
     */
    @GetMapping("/api/weixin/message/subscription/deleteByBusinessCodes")
    Response deleteByBusinessCodes(@RequestBody List<String> businessCodes);

    /*********************************************   liangyongtong 小程序订阅消息 end   ********************************************************************/

    /*********************************************   yinshihao 对接平台白名单 start   ********************************************************************/
    /**
     * 获取对接平台的白名单列表
     *
     * @param platformCode 对接平台编码
     * @return
     */
    @GetMapping("/api/basic/dockingPlatformIpAddr/findDockingPlatformIpAddrList")
    Response<List<DockingPlatformIpAddr>> findDockingPlatformIpAddrList(@RequestParam(value = "platformCode") String platformCode);

    /**
     * 更新对接平台的白名单列表
     *
     * @param platformCode              对接平台编码
     * @param dockingPlatformIpAddrList 对接平台白名单列表
     * @return
     */
    @PostMapping("/api/basic/dockingPlatformIpAddr/updateDockingPlatformIpAddrList")
    Response updateDockingPlatformIpAddrList(@RequestParam(value = "platformCode") String platformCode, @RequestBody List<DockingPlatformIpAddr> dockingPlatformIpAddrList);

    /*********************************************   lyinshihao 对接平台白名单 end   ********************************************************************/

    /*********************************************   ranxiangfu 接口请求日志 start   ********************************************************************/
    /**
     * 保存接口请求日志.
     *
     * @param apiRequestLog 接口请求日志对象 {@link com.rocogz.syy.infrastructure.entity.log.ApiRequestLog}
     * @return the response
     */
    @PostMapping("/api/basic/api-request-log")
    Response saveApiRequestLog(@RequestBody ApiRequestLog apiRequestLog);

    /**
     * 创建指定月份的接口请求日志ES索引.
     *
     * @param yearAndMonth the year and month
     * @return the response
     */
    @PutMapping("/api/basic/api-request-log/createEsIndex")
    Response createApiRequestLogEsIndex(@RequestParam(value = "yearAndMonth") String yearAndMonth);
    /*********************************************   ranxiangfu 接口请求日志 end   ********************************************************************/

    /*********************************************  huhailong 接口请求日志 重载  start ********************************************************************/
    /**
     * 分页查询
     *
     * @param skyWalkingTid     skyWalkingTid
     * @param requestUrl        请求url
     * @param requestType       请求类型
     * @param usedTimeMin       响应最小时间
     * @param usedTimeMax       响应最大时间
     * @param currentUserCode   用户编码
     * @param currentUserOpenid 用户openId
     * @param currentUserMobile 用户手机号
     * @param className         请求接口类名
     * @param methodName        请求接口方法名
     * @param startTime         请求开始时间，已 请求开始时间做判断
     * @param endTime           请求结束时间，已 请求开始时间做判断
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/api/basic/api-request-log/pageQuery")
    PageTable<ApiRequestLog> pageQueryApiRequestLog(
            @RequestParam(value = "skyWalkingTid", required = false) String skyWalkingTid,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "requestType", required = false) String requestType,
            @RequestParam(value = "usedTimeMin", required = false) Integer usedTimeMin,
            @RequestParam(value = "usedTimeMax", required = false) Integer usedTimeMax,
            @RequestParam(value = "currentUserCode", required = false) String currentUserCode,
            @RequestParam(value = "currentUserOpenid", required = false) String currentUserOpenid,
            @RequestParam(value = "currentUserMobile", required = false) String currentUserMobile,
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime", required = false) LocalDateTime startTime,
            @RequestParam(value = "endTime", required = false) LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 主要是配合在折线图中会选择查询的接口，需要进行去重操作，只返回，className,classMethod,requestUrl
     *
     * @param className  类名
     * @param methodName 方法名
     * @param requestUrl 请求url
     * @param startTime  必填写
     * @param endTime    必填写
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/api/basic/api-request-log/pageQueryDistinctApiRequestInterface")
    PageTable<ApiRequestLog> pageQueryDistinctApiRequestInterface(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 只返回StartTime，UsedTimeMillis,配合折线图组装数据
     *
     * @param className  类名
     * @param methodName 方法名
     * @param startTime  查询开始时间
     * @param endTime    查询结束时间
     * @return
     */
    @GetMapping("/api/basic/api-request-log/getStartTimeAndUsedTimeMillisList")
    Response<List<ApiRequestLog>> getStartTimeAndUsedTimeMillisList(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime);


    /**
     * 返回这段时间最大耗时和平均最大耗时数据
     *
     * @param startTime 查询时间段 已开始时间为标准,必须填写
     * @param endTime   查询时间段 已开始时间为标准，必须填写
     * @param limit     返回多少条数据
     * @return
     */
    @GetMapping("/api/basic/api-request-log/statisticsApiMaxAndAverageUserTimeList")
    Response<ApiRequestLogStatisticsResponseDto> statisticsApiMaxAndAverageUserTimeList(
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "limit", defaultValue = "10") Integer limit);


    /*********************************************  huhailong 接口请求日志  end ********************************************************************/


    /*********************************************   zhangmin 商户端接口请求日志 start   ********************************************************************/

    /**
     * 保存接口请求日志.
     */
    @PostMapping("/api/basic/merchant-api-request-log/save")
    Response saveMerchantApiRequestLog(@RequestBody MerchantApiRequestLog apiRequestLog);

    /**
     * 分页查询
     *
     * @param requestUrl         请求url
     * @param usedTimeMin        响应最小时间
     * @param usedTimeMax        响应最大时间
     * @param currentAccountCode 门店账号
     * @param currentUserOpenid  门店账号openId
     * @param currentUserMobile  门店账号手机号
     * @param className          请求接口类名
     * @param methodName         请求接口方法名
     * @param startTime          请求开始时间，已请求开始时间做判断
     * @param endTime            请求结束时间，已请求开始时间做判断
     */
    @GetMapping("/api/basic/merchant-api-request-log")
    PageTable<MerchantApiRequestLog> findMerchantApiRequestLogs(
            @RequestParam(value = "skyWalkingTid", required = false) String skyWalkingTid,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "usedTimeMin", required = false) Integer usedTimeMin,
            @RequestParam(value = "usedTimeMax", required = false) Integer usedTimeMax,
            @RequestParam(value = "currentAccountCode", required = false) String currentAccountCode,
            @RequestParam(value = "currentUserOpenid", required = false) String currentUserOpenid,
            @RequestParam(value = "currentUserMobile", required = false) String currentUserMobile,
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime", required = false) LocalDateTime startTime,
            @RequestParam(value = "endTime", required = false) LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 主要是配合在折线图筛选 查询的接口，需要去重操作，只返回，className,classMethod,requestUrl
     */
    @GetMapping("/api/basic/merchant-api-request-log/distinctHandleMethod")
    PageTable<MerchantApiRequestLog> distinctMerchantApiLogHandleMethod(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 只返回StartTime，UsedTimeMillis,配合折线图组装数据
     *
     * @param className  类名
     * @param methodName 方法名
     * @param startTime  查询开始时间
     * @param endTime    查询结束时间
     */
    @GetMapping("/api/basic/merchant-api-request-log/findApiLogList")
    Response<List<MerchantApiRequestLog>> findMerchantApiLogListByTimeRange(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime);


    /**
     * 统计选定时间 topN 最大耗时和平均最大耗时数据
     *
     * @param startTime 查询时间段 已开始时间为标准,必须填写
     * @param endTime   查询时间段 已开始时间为标准，必须填写
     */
    @GetMapping("/api/basic/merchant-api-request-log/statisSpendTopN")
    Response<ApiRequestLogStatisticsResponseDto> statisMerchantApiLogMaxAvgSpendTopN(
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "topN", defaultValue = "10") Integer topN);


    /*********************************************  zhangmin 商户端接口请求日志  end ********************************************************************/


    /*********************************************   ranxiangfu 特惠商城端接口请求日志 start   ********************************************************************/

    /**
     * 保存接口请求日志.
     */
    @PostMapping("/api/basic/mall-api-request-log/save")
    Response saveMallApiRequestLog(@RequestBody MallApiRequestLog apiRequestLog);

    /**
     * 分页查询
     *
     * @param skyWalkingTid      skyWalkingTid
     * @param requestUrl         请求url
     * @param usedTimeMin        响应最小时间
     * @param usedTimeMax        响应最大时间
     * @param currentAccountCode 门店账号
     * @param currentUserOpenid  门店账号openId
     * @param currentUserMobile  门店账号手机号
     * @param className          请求接口类名
     * @param methodName         请求接口方法名
     * @param startTime          请求开始时间，已请求开始时间做判断
     * @param endTime            请求结束时间，已请求开始时间做判断
     * @param page               page
     * @param limit              limit
     * @return page
     */
    @GetMapping("/api/basic/mall-api-request-log")
    PageTable<MallApiRequestLog> findMallApiRequestLogs(
            @RequestParam(value = "skyWalkingTid", required = false) String skyWalkingTid,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "usedTimeMin", required = false) Integer usedTimeMin,
            @RequestParam(value = "usedTimeMax", required = false) Integer usedTimeMax,
            @RequestParam(value = "currentAccountCode", required = false) String currentAccountCode,
            @RequestParam(value = "currentUserOpenid", required = false) String currentUserOpenid,
            @RequestParam(value = "currentUserMobile", required = false) String currentUserMobile,
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime", required = false) LocalDateTime startTime,
            @RequestParam(value = "endTime", required = false) LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 主要是配合在折线图筛选 查询的接口，需要去重操作，只返回，className,classMethod,requestUrl
     */
    @GetMapping("/api/basic/mall-api-request-log/distinctHandleMethod")
    PageTable<MallApiRequestLog> distinctMallApiLogHandleMethod(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 只返回StartTime，UsedTimeMillis,配合折线图组装数据
     *
     * @param className  类名
     * @param methodName 方法名
     * @param startTime  查询开始时间
     * @param endTime    查询结束时间
     */
    @GetMapping("/api/basic/mall-api-request-log/findApiLogList")
    Response<List<MallApiRequestLog>> findMallApiLogListByTimeRange(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime);


    /**
     * 统计选定时间 topN 最大耗时和平均最大耗时数据
     *
     * @param startTime 查询时间段 已开始时间为标准,必须填写
     * @param endTime   查询时间段 已开始时间为标准，必须填写
     */
    @GetMapping("/api/basic/mall-api-request-log/statisSpendTopN")
    Response<ApiRequestLogStatisticsResponseDto> statisMallApiLogMaxAvgSpendTopN(
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "topN", defaultValue = "10") Integer topN);


    /*********************************************  ranxiangfu 特惠商城端接口请求日志  end ********************************************************************/

    /*********************************************   liangyongtong B端接口请求日志 start   ********************************************************************/

    /**
     * 保存接口请求日志.
     */
    @PostMapping("/api/basic/agent-api-request-log/save")
    Response saveAgentApiRequestLog(@RequestBody AgentApiRequestLog apiRequestLog);

    /**
     * 分页查询
     *
     * @param requestUrl         请求url
     * @param usedTimeMin        响应最小时间
     * @param usedTimeMax        响应最大时间
     * @param currentAccountCode 门店账号
     * @param currentUserOpenid  门店账号openId
     * @param currentUserMobile  门店账号手机号
     * @param className          请求接口类名
     * @param methodName         请求接口方法名
     * @param startTime          请求开始时间，已请求开始时间做判断
     * @param endTime            请求结束时间，已请求开始时间做判断
     */
    @GetMapping("/api/basic/agent-api-request-log")
    PageTable<AgentApiRequestLog> findAgentApiRequestLogs(
            @RequestParam(value = "skyWalkingTid", required = false) String skyWalkingTid,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "usedTimeMin", required = false) Integer usedTimeMin,
            @RequestParam(value = "usedTimeMax", required = false) Integer usedTimeMax,
            @RequestParam(value = "currentAccountCode", required = false) String currentAccountCode,
            @RequestParam(value = "currentUserOpenid", required = false) String currentUserOpenid,
            @RequestParam(value = "currentUserMobile", required = false) String currentUserMobile,
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime", required = false) LocalDateTime startTime,
            @RequestParam(value = "endTime", required = false) LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 主要是配合在折线图筛选 查询的接口，需要去重操作，只返回，className,classMethod,requestUrl
     */
    @GetMapping("/api/basic/agent-api-request-log/distinctHandleMethod")
    PageTable<AgentApiRequestLog> distinctAgentApiLogHandleMethod(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "requestUrl", required = false) String requestUrl,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * 只返回StartTime，UsedTimeMillis,配合折线图组装数据
     *
     * @param className  类名
     * @param methodName 方法名
     * @param startTime  查询开始时间
     * @param endTime    查询结束时间
     */
    @GetMapping("/api/basic/agent-api-request-log/findApiLogList")
    Response<List<AgentApiRequestLog>> findAgentApiLogListByTimeRange(
            @RequestParam(value = "className", required = false) String className,
            @RequestParam(value = "methodName", required = false) String methodName,
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime);


    /**
     * 统计选定时间 topN 最大耗时和平均最大耗时数据
     *
     * @param startTime 查询时间段 已开始时间为标准,必须填写
     * @param endTime   查询时间段 已开始时间为标准，必须填写
     */
    @GetMapping("/api/basic/agent-api-request-log/statisSpendTopN")
    Response<ApiRequestLogStatisticsResponseDto> statisAgentApiLogMaxAvgSpendTopN(
            @RequestParam(value = "startTime") LocalDateTime startTime,
            @RequestParam(value = "endTime") LocalDateTime endTime,
            @RequestParam(value = "topN", defaultValue = "10") Integer topN);


    /*********************************************  liangyongtong B端接口请求日志  end ********************************************************************/

    /*********************************************  huhailong 数据权限管理相关 begin ********************************************************************/

    /**
     * 获取所有的数据权限
     *
     * @param userId
     * @return
     */
    @RequestMapping("/api/system/datapermission/getUserDataPermissionByUserId")
    List<UserDataPermission> getUserDataPermissionByUserId(@RequestParam("userId") Integer userId);

    /**
     * 设置数据权限
     *
     * @param userId      用户ID
     * @param permissions 权限
     * @return
     */
    @PostMapping(value = "/api/system/datapermission/permission/{userId}")
    Response setUserDataPermission(@PathVariable("userId") Integer userId, @RequestBody List<UserDataPermission> permissions);


    /**
     * 菜单修改弹出层的菜单,返回菜单列表 修改父级菜单时可以选择任意菜单，除了自己和自己的子级
     *
     * @return
     */
    @GetMapping("/api/menu/findCanSelectedMenuTree")
    Response<List<MenuTreeDto>> findCanSelectedMenuTree(@RequestParam("currentId") Integer currentId,
                                                        @RequestParam(value = "systemCode", required = false) String systemCode);

    /*********************************************  huhailong 数据权限管理相关 end ********************************************************************/

    /*********************************************  lanqian 微信开发平台扫码登录，微信登录权限激活 begin*************************************************/
    /**
     * 新增激活码
     *
     * @param dto
     * @return Response
     */

    @PostMapping("/api/wxCipher/apply")
    Response applyWxCipher(@RequestBody PlatformUserCipherDto dto);

    /**
     * 分页查询激活码
     *
     * @param page
     * @param limit
     * @param mobile
     * @param name
     * @param status
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/search")
    PageTable<PlatformUserCipher> searchWxCipherList(@RequestParam(value = "limit", defaultValue = "20") int limit,
                                                     @RequestParam(value = "page", defaultValue = "1") int page,
                                                     @RequestParam(value = "systemCode", required = false) String systemCode,
                                                     @RequestParam(value = "mobile", required = false) String mobile,
                                                     @RequestParam(value = "name", required = false) String name,
                                                     @RequestParam(value = "status", required = false) String status);

    /**
     * 删除激活码
     *
     * @param id
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/delete/{id}")
    Response removeWxCipher(@PathVariable(value = "id") Long id);

    /**
     * 按手机号码和类型查询记录
     *
     * @param mobile
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/getByMobile")
    Response<PlatformUserCipher> getWxCipherByMobile(@RequestParam(value = "mobile", required = false) String mobile,
                                                     @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 按微信openid和类型查询记录
     *
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/getByOpenId")
    Response<PlatformUserCipher> getWxCipherByOpenId(@RequestParam(value = "openId", required = false) String openId);

    /**
     * 按openid和类型检查是否被激活
     *
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wxCipher/checkActivation")
    Response<Boolean> checkWxCipherActivation(@RequestParam(value = "openId", required = false) String openId);

    /**
     * 更新
     *
     * @param entity
     * @return Response
     */
    @PostMapping(value = "/api/wxCipher/update")
    boolean updateWxCipher(@RequestBody PlatformUserCipher entity);

    /*********************************************  lanqian 微信开发平台扫码登录，微信登录权限激活 end*************************************************/

    /*********************************************  lanqian 微信开发平台扫码登录 begin*************************************************/
    /**
     * 获取平台用户和微信的绑定关系
     *
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/getByOpenId")
    Response<List<WechatOpenAdminUser>> getAdminUserByOpenId(@RequestParam(value = "openId", required = false) String openId,
                                                             @RequestParam(value = "type", required = false) String type,
                                                             @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 获取平台用户和微信的绑定关系
     *
     * @param acctName
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/getByAcctName")
    Response<WechatOpenAdminUser> getAdminUserByAcctName(@RequestParam(value = "acctName", required = false) String acctName,
                                                         @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 删除平台用户和微信的绑定关系
     *
     * @param openId
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/deleteByOpenId")
    Response<Boolean> deleteAdminUserByOpenId(@RequestParam(value = "openId", required = false) String openId);

    /**
     * 删除平台用户和微信的绑定关系
     *
     * @param acctName
     * @return Response
     */
    @GetMapping(value = "/api/wechatOpenAdminUser/deleteByAcctName")
    Response<Boolean> deleteAdminUserByAcctName(@RequestParam(value = "acctName", required = false) String acctName,
                                                @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 插入平台用户和平台用户的绑定关系
     */
    @PostMapping(value = "/api/wechatOpenAdminUser/insert")
    Response<Boolean> insertAdminUser(@RequestBody WechatOpenAdminUser wechatOpenAdminUser);

    /**
     * 记录日志
     */
    @PostMapping("/api/wechatOpenLoginLog/insert")
    Response<Boolean> insertWechatOpenLoginLog(@RequestBody WechatOpenLoginLog wechatOpenLoginLog);

    /**
     * 更新或者插入记录
     *
     * @param wechatOpenUserinfo
     * @return
     */
    @PostMapping("/api/wechatOpenUserInfo/saveOrUpdateUser")
    Response<Boolean> saveOrUpdateUserinfo(@RequestBody WechatOpenUserinfo wechatOpenUserinfo);

    /**
     * 根据openid获取记录
     *
     * @param openId
     * @return
     */
    @GetMapping(value = "/api/wechatOpenUserInfo/getByOpenId")
    Response<WechatOpenUserinfo> getUserInfoByOpenId(@RequestParam(value = "openId", required = false) String openId);

    /**
     * 根据用户id列表查询用户
     *
     * @param ids
     * @return
     */
    @GetMapping("/api/system/users/listUserByUserIds")
    Response<List<AdminUser>> listUserByUserIds(@RequestParam(value = "ids") List<Integer> ids);

    /**
     * 根据本地临时凭证token获取记录
     *
     * @param token
     * @return
     */
    @GetMapping(value = "/api/wechatOpenUserInfo/getByToken")
    Response<WechatOpenUserinfo> getUserInfoByToken(@RequestParam(value = "token", required = false) String token);

    /*********************************************  lanqian 微信开发平台扫码登录 end*************************************************/

    /**
     * 根据用户id和角色类型查询用户角色信息
     *
     * @param id         用户id
     * @param roleType   角色类型
     * @param systemCode 所属项目编码
     * @return
     */
    @GetMapping("/api/system/role/role/{id}/{roleType}")
    Response<List<Role>> getRolesByUserIdAndRoleType(@PathVariable("id") Long id, @PathVariable("roleType") String roleType,
                                                     @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 根据用户id和角色类型为用户设置角色信息
     *
     * @param id       用户id
     * @param roleIds  角色ids
     * @param roleType 角色类型
     * @return
     */
    @PostMapping("/api/system/users/role/{id}/{roleType}")
    Response setAdminUserRolesByIdAndRoleType(@PathVariable("id") Long id, @RequestParam("roleIds") long[] roleIds, @PathVariable("roleType") String roleType);

    /**
     * 根据用户id和角色类型为用户设置角色信息
     *
     * @param mobile
     * @param systemCode 所属项目
     * @return
     */
    @GetMapping("/api/system/users/register")
    Response register(@RequestParam("mobile") String mobile, @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 根据用户id和角色类型为用户设置角色信息
     *
     * @param mobile
     * @param systemCode 所属项目
     * @return
     */
    @GetMapping("/api/system/users/unRegister")
    Response unRegister(@RequestParam("mobile") String mobile, @RequestParam(value = "systemCode", required = false) String systemCode);

    /**
     * 根据发放主体编号查询可以候选团队成员
     *
     * @param searchDTO
     * @return
     */
    @PostMapping("/api/system/users/selectCandidateTeamUser")
    PageTable<AdminUser> selectCandidateTeamUser(@SpringQueryMap AdminUserSearchDTO searchDTO);

    /**
     * 根据用户id查找关联的账号信息
     *
     * @param userId
     * @return
     */
    @GetMapping("/api/system/users/adminUserInfo")
    Response<AdminUserInfo> getAdminUserInfoByUserId(@RequestParam("userId") Integer userId);

    /**
     * 新增发放主体用户
     *
     * @param user
     * @return
     */
    @PostMapping("/api/system/user/issuingBody")
    Response<Boolean> createIssuingBodyUser(@RequestBody AdminUser user);

    /**
     * 编辑发放主体用户
     *
     * @param user
     * @return
     */
    @PostMapping("/api/system/user/issuingBody/edit")
    Response editIssuingBodyUser(@RequestBody AdminUser user);


    // ============= start of 小程序配置信息表 by luoyc==================
    @PostMapping("/api/system/app/config/queryPage")
    PageTable<BasicWxMiniAppConfig> appConfigPageTable(@RequestBody BasicWxMiniAppConfig basicWxMiniAppConfig);

    @PostMapping("/api/system/app/config/saveOrUpdate")
    Response appConfigSaveOrUpdate(@RequestBody BasicWxMiniAppConfig basicWxMiniAppConfig);

    @GetMapping("/api/system/app/config/gainByMiniAppid/{miniAppid}")
    Response<BasicWxMiniAppConfig> gainByMiniAppid(@PathVariable(value = "miniAppid") String miniAppid);

    /**
     * <<<<<<< Updated upstream
     * 根据appid列表查询appid和name信息，用于数据回显
     *
     * @param miniAppidList
     * @return
     * @see IInfrastructureClientService#listAppConfigWithoutSecret(java.util.List)
     */
    @Deprecated
    @GetMapping("/api/system/app/config/listAppidAndName")
    List<BasicWxMiniAppConfig> listAppidAndName(@RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList);

    /**
     * 根据appid列表查询除了secret之外的所有数据，用于数据回显
     *
     * @param miniAppidList
     * @return
     */
    @GetMapping("/api/system/app/config/listAppConfigWithoutSecret")
    List<BasicWxMiniAppConfig> listAppConfigWithoutSecret(@RequestParam(value = "miniAppidList", required = false) List<String> miniAppidList);

    /**
     * huhl
     * 返回数据权限要使用的所有小程序，仅仅返回appid,name
     *
     * @return
     */
    @GetMapping("/api/system/app/config/getDataPNeedMiniAppConfigList")
    Response<List<BasicWxMiniAppConfig>> getDataPNeedMiniAppConfigList();

    /**
     * 根据服务平台编码查询小程序配置信息
     *
     * @param servicePlatformCode 服务平台编码
     * @return Response
     */
    @GetMapping("/api/system/app/config/getByServicePlatformCodeWithoutSecret")
    Response<BasicWxMiniAppConfig> getByServicePlatformCodeWithoutSecret(
            @RequestParam(value = "servicePlatformCode") String servicePlatformCode);

    /**
     * 查询小程序配置信息和系统运行模式信息
     *
     * @param miniAppid
     * @return
     */
    @GetMapping("/api/system/app/config/getWxMiniAppConfigAndRunManagerInfo")
    Response<BasicWxMiniAppConfig> getWxMiniAppConfigAndRunManagerInfo(@RequestParam("miniAppid") String miniAppid);
    // ============= end of 小程序配置信息表 by luoyc==================

    // ============= start of 微信收款商户配置信息表 by luoyc==================
    @PostMapping("/api/basic/mch/config/queryPage")
    PageTable<BasicWxPaymentMchConfig> mchConfigPageTable(@RequestBody BasicWxPaymentMchConfig basicWxPaymentMchConfig);

    @PostMapping("/api/basic/mch/config/saveOrUpdate")
    Response mchConfigSaveOrUpdate(@RequestBody BasicWxPaymentMchConfig basicWxPaymentMchConfig);

    @GetMapping("/api/basic/mch/config/gainByMchId/{mchId}")
    Response<BasicWxPaymentMchConfig> gainByMchId(@PathVariable(value = "mchId") String mchId);

    @GetMapping("/api/basic/mch/config/findAllWxPaymentMchConfig")
    Response<List<BasicWxPaymentMchConfig>> findAllWxPaymentMchConfig();
    // ============= end of 微信收款商户配置信息表 by luoyc==================

    @GetMapping("/api/system/app/config/listAllByServicePlatformCodes")
    Response<List<BasicWxMiniAppConfig>> listAllByServicePlatformCodes(@RequestParam(value = "servicePlatformCodes", required = false) List<String> servicePlatformCodes);
    // ============= start of 发放主体关联角色 by yinshihao==================

    /**
     * 根据发放主体code查询关联角色信息
     *
     * @param code 发放主体code
     * @return
     */
    @GetMapping("/api/basic/issuingbodyrole/getIssuingBodyRoleByCode")
    Response<List<BasicIssuingBodyRole>> getIssuingBodyRoleByCode(@RequestParam("code") String code);

    /**
     * 创建或更新发放主体关联角色
     *
     * @param issuingBodyRoleList
     * @return
     */
    @GetMapping("/api/basic/issuingbodyrole/saveOrUpdateIssuingBodyRole")
    Response saveOrUpdateIssuingBodyRole(@RequestParam("code") String code,
                                         @RequestParam(value = "issuingBodyRoleList", required = false) List<Integer> issuingBodyRoleList);
    // ============= end of 发放主体关联角色 by yinshihao==================


    /**
     * 列表
     *
     * @param basicSystemRunManageReq
     * @return
     */
    @PostMapping("/api/basic/systemRun/queryPage")
    PageTable<BasicSystemRunManageRes> systemRunManagePageTable(@RequestBody BasicSystemRunManageReq basicSystemRunManageReq);

    /**
     * 列表
     *
     * @param basicWxMiniAppConfig
     * @return
     */
    @PostMapping("/api/basic/systemRun/component/page")
    PageTable<BasicWxMiniAppConfig> systemRunManageComponentTable(@RequestBody BasicWxMiniAppConfig basicWxMiniAppConfig);

    /**
     * 维护运转模式
     *
     * @param basicSystemRunManage maintainType
     *                             systemRunType
     *                             systemUpgradeType
     *                             content
     *                             remark
     *                             updateTime
     *                             updateUser
     * @return
     */
    @PostMapping("/api/basic/systemRun/updateManage")
    Response systemRunManageUpdateManage(@RequestBody BasicSystemRunManage basicSystemRunManage);

    /**
     * 批量维护运转模式
     *
     * @param basicSystemRunManage maintainType
     *                             systemRunType
     *                             systemUpgradeType
     *                             content
     *                             remark
     *                             updateTime
     *                             updateUser
     *                             ids
     * @return
     */
    @PostMapping("/api/basic/systemRun/batchUpdateManage")
    Response systemRunManageBatchUpdateManage(@RequestBody BasicSystemRunManage basicSystemRunManage);

    /**
     * 列表
     *
     * @param basicSystemRunManageLog
     * @return
     */
    @PostMapping("/api/basic/systemRunLog/queryPage")
    PageTable<BasicSystemRunManageLog> systemRunLogPageTable(@RequestBody BasicSystemRunManageLog basicSystemRunManageLog);

    @GetMapping("/api/basic/systemRun/getBasicSystemRunManageByAppid")
    Response<BasicSystemRunManage> getBasicSystemRunManageByAppid(@RequestParam("miniAppid") String miniAppid);


    /**
     * huhl 添加,分销下游订单列表查询名称,服务平台编号
     *
     * @param platformCodes
     * @return
     */
    @PostMapping("/api/system/app/config/getServicePlatformByCodeList")
    Response<List<BasicWxMiniAppConfig>> getServicePlatformByCodeList(@RequestBody List<String> platformCodes);


    /**
     * 保存团队
     *
     * @param editDTO
     * @return 团队编号
     */
    @PostMapping("/api/basic/teamInfo/save")
    Response<String> saveTeamInfo(@RequestBody @Validated BasicTeamInfoEditDTO editDTO);


    /**
     * 更新团队
     *
     * @param editDTO
     * @return
     */
    @PostMapping("/api/basic/teamInfo/update")
    Response updateTeamInfo(@RequestBody @Validated BasicTeamInfoEditDTO editDTO);

    /**
     * 分页查询团队
     *
     * @param searchDTO
     * @return
     */
    @PostMapping("/api/basic/teamInfo/listPageByParams")
    PageTable<BasicTeamInfo> listPageTeamInfoByParams(@SpringQueryMap BasicTeamInfoSearchDTO searchDTO);

    /**
     * 不分页查询团队
     *
     * @return
     */
    @PostMapping("/api/basic/teamInfo/listAllByParams")
    Response<List<BasicTeamInfo>> listAllTeamInfoByParams(@SpringQueryMap BasicTeamInfoSearchDTO searchDTO);

    /**
     * 更新团队状态
     *
     * @param id
     * @param afterStatus
     * @return
     */
    @GetMapping("/api/basic/teamInfo/updateStatus")
    Response updateTeamInfoStatus(@RequestParam("id") Integer id, @RequestParam("afterStatus") String afterStatus);


    /**
     * 团队详情(包括团队成员)
     *
     * @param teamCode 团队编号
     * @return
     */
    @GetMapping("/api/basic/teamInfo/detailByTeamCode")
    Response<BasicTeamInfoDetailDTO> getTeamDetailByTeamCode(@RequestParam("teamCode") String teamCode);

    /**
     * 团队信息（不包括团队成员）
     *
     * @param teamCode 团队编号
     * @return
     */
    @GetMapping("/api/basic/teamInfo/getByTeamCode")
    Response<BasicTeamInfo> getTeamInfoByTeamCode(@RequestParam("teamCode") String teamCode);

    /**
     * 礼赠平台 查看
     *
     * @param username
     * @return
     */
    @GetMapping("/api/basic/teamInfo/myTeam")
    Response<TeamStatisticsDTO> myTeamInfo(@RequestParam("username") String username);

    /**
     * 根据团队编码查询团队配置的短信模板
     *
     * @param teamCode 团队编码
     * @return
     */
    @GetMapping("/api/basic/teamInfo/getMsgTemplate")
    Response<String> getTeamInfoMsgTemplate(@RequestParam(name = "teamCode") String teamCode);

    /**
     * 保存团队的短信模板配置
     *
     * @param teamCode        团队编码
     * @param msgTemplateCode 短信模板编码
     * @return
     */
    @GetMapping("/api/basic/teamInfo/saveMsgTemplate")
    Response saveTeamInfoMsgTemplate(@RequestParam(name = "teamCode") String teamCode,
                                     @RequestParam(name = "msgTemplateCode") String msgTemplateCode);

    /**
     * 删除团队的短信模板配置
     *
     * @param teamCode 团队编码
     * @return
     */
    @GetMapping("/api/basic/teamInfo/deleteMsgTemplate")
    Response deleteTeamInfoMsgTemplate(@RequestParam(name = "teamCode") String teamCode);

    /**
     * 判断是否有团队使用指定发放主体下的指定短信模板（发放主体删除短信模板时判断用）
     *
     * @param issuingBodyCode 发放主体编码
     * @param msgTemplateCode 短信模板编码
     * @return
     */
    @GetMapping("/api/basic/teamInfo/judgeMsgTemplateUsed")
    Response<Boolean> judgeTeamInfoMsgTemplateUsed(@RequestParam(name = "issuingBodyCode") String issuingBodyCode,
                                                   @RequestParam(name = "msgTemplateCode") String msgTemplateCode);

    /**
     * 不分页查询团队成员
     *
     * @param searchDTO
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/listAllByParam")
    Response<List<BasicTeamUserInfo>> listAllTeamUserByParam(@SpringQueryMap BasicTeamUserInfoSearchDTO searchDTO);


    /**
     * 分页查询团队成员
     *
     * @param searchDTO
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/listPageByParams")
    PageTable<BasicTeamUserInfo> listPageTeamUserByParam(@SpringQueryMap BasicTeamUserInfoSearchDTO searchDTO);


    /**
     * 新增团员
     *
     * @param saveDTO
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/add")
    Response addTeamUser(@RequestBody BasicTeamUserInfoAddDTO saveDTO);


    /**
     * 移除团员
     *
     * @param commonDTO
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/remove")
    Response removeTeamUser(@SpringQueryMap BasicTeamUserCommonDTO commonDTO);


    /**
     * 设置团队长
     *
     * @param commonDTO
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/setLeader")
    Response setTeamLeader(@SpringQueryMap BasicTeamUserCommonDTO commonDTO);

    /**
     * 获取团队长
     *
     * @param teamCode
     * @return
     */
    @GetMapping("/api/basic/teamUserInfo/getTeamLeader")
    Response<BasicTeamUserInfo> getTeamLeader(@RequestParam("teamCode") String teamCode);

    /**
     * huhl数据权限使用,得到团队编码和名字
     *
     * @return
     */
    @RequestMapping("/api/basic/teamInfo/listTeamCodeAndName")
    Response<List<BasicTeamInfo>> listTeamCodeAndName();

    /**
     * 根据团队编码列表查询团队信息
     *
     * @return
     */
    @RequestMapping("/api/basic/teamInfo/listTeamInfoByCodeList")
    Response<List<BasicTeamInfo>> listTeamInfoByCodeList(@RequestParam("codeList") List<String> codeList);

    /**
     * 根据团队编码删除团队
     *
     * @param teamCode
     * @return
     */
    @RequestMapping("/api/basic/teamInfo/deleteByTeamCode")
    Response deleteByTeamCode(@RequestParam("teamCode") String teamCode);

    /**
     * 根据用户id获取团队信息
     *
     * @param userId
     * @return
     */
    @GetMapping("/api/basic/teamUserInfo/getTeamByUserId")
    Response<BasicTeamUserInfo> getTeamByUserId(@RequestParam("userId") Integer userId);


    /**
     * 根据用户名列表查询团队成员列表
     *
     * @param usernameList
     * @return
     */
    @GetMapping("/api/basic/teamUserInfo/listByUserUsernameList")
    Response<List<BasicTeamUserInfo>> listByUserUsernameList(@RequestParam("usernameList") List<String> usernameList);


    /**
     * 根据用户名获取团队信息
     *
     * @param username
     * @return
     */
    @GetMapping("/api/basic/teamUserInfo/getTeamByUsername")
    Response<BasicTeamUserInfo> getTeamByUsername(@RequestParam("username") String username);

    /**
     * 根据用户名获取团队信息
     *
     * @param usernames
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/getTeamByUsernames")
    Response<List<BasicTeamUserInfo>> getTeamByUsernames(@RequestBody List<String> usernames);

    /**
     * 礼赠服务平台 我的队员->全部（经理视角）
     *
     * @param dto
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/listUserWithTeamInfo")
    Response<List<BasicTeamUserInfo>> listUserWithTeamInfo(@SpringQueryMap BasicTeamInfoSearchDTO dto);

    /**
     * 礼赠服务平台 我的队员->已分配团队（经理视角）
     *
     * @param dto
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/listUserBelongTeam")
    Response<List<BasicTeamUserInfo>> listUserBelongTeam(@SpringQueryMap BasicTeamInfoSearchDTO dto);

    /**
     * 礼赠服务平台 我的队员->已分配团队（经理视角）
     *
     * @param dto
     * @return
     */
    @PostMapping("/api/basic/teamUserInfo/listUserBeyondTeam")
    Response<List<BasicTeamUserInfo>> listUserBeyondTeam(@SpringQueryMap BasicTeamInfoSearchDTO dto);

    /**
     * 礼赠服务平台 赠服务平台 账号统计
     *
     * @param issuingBodyCode
     * @return
     */
    @GetMapping("/api/basic/teamUserInfo/userStatistics")
    Response<TeamUserStatisticsDTO> teamUserStatistics(@RequestParam("issuingBodyCode") String issuingBodyCode);

    /*********************************************   yinshihao 用户请求日志 start   ********************************************************************/
    /**
     * 保存用户请求日志.
     *
     * @param userRequestLog 用户请求日志对象
     * @return the response
     */
    @PostMapping("/api/basic/user-request-log")
    Response saveUserRequestLog(@RequestBody BasicUserRequestLog userRequestLog);
    /*********************************************   yinshihao 用户请求日志 end   ********************************************************************/

    /**
     * 数据权限-->平台和专区返回构建好的数据权限
     *
     * @param userId
     * @return
     */
    @RequestMapping("/api/system/datapermission/getDPMiniAppPrefectureTree")
    public Response<List<DPMiniAppPrefectureTreeDto>> getDPMiniAppPrefectureTree();

    /**
     * 检查是否激活过微信
     *
     * @param openId
     * @param userType
     * @param systemCode
     * @return
     */
    @GetMapping("/api/wechat/record/checkWechatActivate")
    Response<Boolean> checkWechatActivate(@RequestParam("openId") String openId,
                                          @RequestParam("userType") String userType,
                                          @RequestParam("systemCode") String systemCode);


    /**
     * 查询微信关联的后台管理账号
     *
     * @param openId
     * @param acctName
     * @param systemCode
     * @return
     */
    @GetMapping("/api/wechatOpenAdminUser/getByAcctNameAndOpenId")
    Response<WechatOpenAdminUser> getByAcctNameAndOpenId(@RequestParam("openId") String openId,
                                                         @RequestParam("acctName") String acctName,
                                                         @RequestParam("systemCode") String systemCode);


    /**
     * 分页查询微信用户
     *
     * @param openId
     * @param type
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/api/wechatOpenAdminUser/pageWechatAdminUser")
    PageTable<WechatOpenAdminUser> pageWechatAdminUser(@RequestParam("openId") String openId,
                                                       @RequestParam("type") String type,
                                                       @RequestParam(value = "page") int page,
                                                       @RequestParam(value = "limit") int limit);

    /**
     * 不分页查询用户
     *
     * @param dto
     * @return
     */
    @GetMapping("/api/system/users/listAllUser")
    Response<List<AdminUser>> listAllUser(@SpringQueryMap AdminUserSearchDTO dto);


    /**
     * 根据手机号查询后台管理账号
     *
     * @param mobile
     * @param status
     * @return
     */
    @GetMapping("/api/system/users/getAdminUserByMobile")
    Response<List<AdminUser>> getAdminUserByMobile(@RequestParam("mobile") String mobile,
                                                   @RequestParam("status") String status);


    /**
     * 不分页查询后台管理用户
     *
     * @param dto
     * @return
     */
    @GetMapping("/api/system/users/listAdminUser")
    Response<List<AdminUser>> listAdminUser(@SpringQueryMap AdminUserSearchDTO dto);

    /**
     * 不分页查询用户
     *
     * @param mobile
     * @param registerStatus
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/api/system/admin/issuingBodyUser/pageByMobile")
    PageTable<IssuingBodyUserResp> pageIssuingBodyUserByMobile(@RequestParam("mobile") String mobile,
                                                               @RequestParam("registerStatus") String registerStatus,
                                                               @RequestParam(value = "page") int page,
                                                               @RequestParam(value = "limit") int limit);

    /**
     * 不分页查询用户
     *
     * @param mobile
     * @return
     */
    @GetMapping("/api/system/admin/issuingBodyUser/listOpenUserByMobile")
    Response<List<IssuingBodyUserResp>> listOpenIssuingBodyUserByMobile(@RequestParam("mobile") String mobile,
                                                                        @RequestParam("userNature") String userNature);

    /**
     * 不分页查询用户
     *
     * @param req
     * @return
     */
    @GetMapping("/api/system/admin/issuingBodyUser/listIssuingBodyUser")
    Response<List<AdminUser>> listIssuingBodyUser(@SpringQueryMap IssuingBodyUserSearchReq req);

    /**
     * 根据激活码获取账号
     *
     * @param cipher
     * @param systemCode
     * @return
     */
    @GetMapping("/api/system/users/getByCipher")
    Response<AdminUser> getUserByCipher(@RequestParam("cipher") String cipher,
                                        @RequestParam("systemCode") String systemCode);


    /**
     * 激活账号
     *
     * @param req
     * @return
     */
    @PostMapping("/api/system/users/activate")
    Response activateUser(@RequestBody UserActivateReq req);


    /**
     * 更新最后一次登录时间
     *
     * @param userId
     * @return
     */
    @GetMapping("/api/system/users/updateLastLoginTime")
    Response updateLastLoginTime(@RequestParam("userId") Integer userId);


    /**
     * 根据发放主体Code 构建一个一级团队的树
     *
     * @param issuingBodyCode
     * @return
     */
    @RequestMapping("/api/system/datapermission/getDPTeamTreeByIssuingBodyCode")
    Response<List<DPTeamTreeDto>> getDPTeamTreeByIssuingBodyCode(@RequestParam("issuingBodyCode") String issuingBodyCode);

    // ========= start 发放主体账号实名认证申请相关接口 by ranxiangfu ============

    /**
     * 分页查询.
     *
     * @param pageQuery the page query
     * @return the page table
     */
    @PostMapping("/api/system/admin/realNameAuthentication/pageQuery")
    PageTable<AdminUserRealNameAuthentication> adminUserRealNameAuthPageTable(
            @RequestBody AdminUserRealNameAuthPageQuery pageQuery);

    /**
     * 根据编码查看主体客户实名认证详情
     *
     * @param code
     * @return
     */
    @GetMapping("/api/system/admin/realNameAuthentication/detail/{code}")
    Response<AdminUserRealNameAuthentication> findAdminUserRealNameAuthDetailByCode(@PathVariable("code") String code);

    /**
     * Save or update admin user real name auth response.
     *
     * @param adminUserRealNameAuthentication the admin user real name authentication
     * @return the response
     */
    @PostMapping("/api/system/admin/realNameAuthentication/saveOrUpdate")
    Response saveOrUpdateAdminUserRealNameAuth(@RequestBody AdminUserRealNameAuthentication adminUserRealNameAuthentication);

    /**
     * Gets last admin user real name auth.
     *
     * @param userId the user id
     * @return the last admin user real name auth
     */
    @GetMapping("/api/system/admin/realNameAuthentication/getLast")
    Response<AdminUserRealNameAuthentication> getLastAdminUserRealNameAuth(@RequestParam(value = "userId") Integer userId);


    @GetMapping("/api/system/admin/realNameAuthentication/getLastByUserIdList")
    Response<Map<Integer, AdminUserRealNameAuthentication>> getLastAdminUserRealNameAuthByUserIdList(@RequestParam(value = "userIdList") List<Integer> userIdList);

    /**
     * Gets last admin user real name auth.
     *
     * @param userId the user id
     * @return the last admin user real name auth
     */
    @GetMapping("/api/system/admin/realNameAuthentication/checkAuthPass")
    Response<Boolean> checkAdminUserRealNameAuthPass(@RequestParam(value = "userId") Integer userId);

    // ========= end 发放主体账号实名认证申请相关接口 by ranxiangfu ============


    // ========= start roco管理端小程序账号相关接口 by dongjuntong ============

    /**
     * 新增roco小程序管理员
     *
     * @param req
     * @return
     */
    @PostMapping("/api/basic/rocoManager/add")
    Response addRocoManager(@RequestBody RocoManagerSaveReq req);

    /**
     * 删除roco小程序管理员
     *
     * @param id
     * @return
     */
    @PostMapping("/api/basic/rocoManager/delete")
    Response deleteRocoManager(@RequestParam("id") Integer id);


    /**
     * 根据用户id列表获取roco管理端账号
     *
     * @param ids
     * @return
     */
    @PostMapping("/api/basic/rocoManager/getByIds")
    Response<List<RocoManager>> getRocoManagerByIds(@RequestBody List<Integer> ids);


    /**
     * 分页查询roco管理端小程序账号
     *
     * @param req
     * @return
     */
    @GetMapping("/api/basic/rocoManager/page")
    PageTable<RocoManagerPageResp> pageRocoManager(@SpringQueryMap RocoManagerPageReq req);


    /**
     * 分页查询roco管理端小程序账号
     *
     * @param req
     * @return
     */
    @GetMapping("/api/basic/rocoManager/pageCandidate")
    PageTable<RocoManagerCandidateResp> PageRocoManagerCandidate(@SpringQueryMap RocoManagerPageReq req);


    // ========= end roco管理端小程序账号相关接口 by dongjuntong ============


    /**
     * 删除用户数据权限,userId,code,codeType做了不空校验
     *
     * @return
     */
    @PostMapping("/api/system/datapermission/delete")
    Response deleteUserDataPermission(@RequestBody UserDataPermission dp);


    /**
     * 根据系统用户集合获取分页
     * add 周展锆 2021/08/10
     *
     * @param ids 用户编号集合
     * @return
     */
    @GetMapping("/api/system/users/getByInIdList")
    PageTable<AdminUser> getAdminUserByInIdList(@RequestParam(name = "ids") List<Integer> ids,
                                                @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 根据系统用户集合获取分页
     * add 周展锆 2021/08/10
     *
     * @param ids 用户编号集合
     * @return
     */
    @GetMapping("/api/system/users/getByNotInIdList")
    PageTable<AdminUser> getAdminUserByNotInIdList(@RequestParam(name = "ids", required = false) List<Integer> ids,
                                                   @RequestParam(name = "userName", required = false) String userName,
                                                   @RequestParam(name = "mobile", required = false) String mobile,
                                                   @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                   @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 获取到所有系统用户
     * add 周展锆 2021/08/10
     *
     * @return
     */
    @GetMapping("/api/system/users/getByAll")
    PageTable<AdminUser> getAdminUserByAll(@RequestParam(name = "userName", required = false) String userName,
                                           @RequestParam(name = "mobile", required = false) String mobile,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 批量保存
     * 周展锆 ADD
     *
     * @return
     */
    @PostMapping("/api/basic/rocoManager/saveBatch")
    Response saveRocoManagerByList(@RequestBody List<RocoManagerDto> rocoManagerList);

    /**
     * 新增账号变更信息
     *
     * @param req
     * @return
     */
    @PostMapping("/api/basic/userLog/create")
    Response createUserLog(@RequestBody UserLogSaveReq req);

    /**
     * 根据账号id查询变更记录
     *
     * @param req
     * @return
     */
    @GetMapping("/api/basic/userLog/page")
    PageTable<UserLogListResp> pageUserLog(@SpringQueryMap UserLogPageReq req);

    /**
     * 根据条件获取团队分页
     *
     * @param teamCode        团队编号
     * @param teamName        团队名称
     * @param issuingBodyCode 所属发放主体
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/api/basic/teamInfo/getBodyTeamPageByParams")
    PageTable<BasicTeamInfo> getBodyTeamPageByParams(@RequestParam(name = "bodyCode", required = false) String bodyCode,
                                                     @RequestParam(name = "teamCode", required = false) String teamCode,
                                                     @RequestParam(name = "teamName", required = false) String teamName,
                                                     @RequestParam(name = "issuingBodyCode", required = false) String issuingBodyCode,
                                                     @RequestParam(name = "notSelectTeamCode", required = false) List<String> notSelectTeamCode,
                                                     @RequestParam(name = "page", defaultValue = "1") int page,
                                                     @RequestParam(name = "limit", defaultValue = "10") int limit);

    /**
     * 根据团队列表获取团队所有成员
     *
     * @param teamCode
     * @return
     */
    @GetMapping("/api/basic/teamUserInfo/getTeamUserPageByTeamList")
    PageTable<BasicTeamUserSelectBoxInfo> getTeamUserPageByTeamList(@RequestParam(name = "bodyCode", required = false) String bodyCode,
                                                                    @RequestParam(name = "name", required = false) String name,
                                                                    @RequestParam(name = "mobile", required = false) String mobile,
                                                                    @RequestParam(name = "teamCode", required = false) String teamCode,
                                                                    @RequestParam(name = "issuingBodyUserType", required = false) String issuingBodyUserType,
                                                                    @RequestParam(name = "status", required = false) String status,
                                                                    @RequestParam(name = "page", defaultValue = "1") Integer page,
                                                                    @RequestParam(name = "limit", defaultValue = "10") Integer limit);
}
