package com.rocogz.syy.infrastructure.entity.log;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-接口请求日志
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("basic_api_request_log")
public class ApiRequestLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 当前接口请求用户的编号
     */
    private String currentUserCode;

    /**
     * 当前接口请求用户的openid
     */
    private String currentUserOpenid;

    /**
     * 当前接口请求用户的手机号
     */
    private String currentUserMobile;

    /**
     * 接口类名称
     */
    private String className;

    /**
     * 接口方法
     */
    private String methodName;

    /**
     * 请求类型
     */
    private String requestType;

    /**
     * 请求url
     */
    private String requestUrl;

    /**
     * 请求参数
     */
    private String requestParams;

    /**
     * 响应数据
     */
    private String response;

    /**
     * 请求开始时间-毫秒
     */
    @TableField(exist = false)
    private Long startTimeMillis;

    /**
     * 请求结束时间-毫秒
     */
    @TableField(exist = false)
    private Long endTimeMillis;

    /**
     * 请求开始时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone = "GMT+08:00")
    private LocalDateTime startTime;

    /**
     * 请求结束时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone = "GMT+08:00")
    private LocalDateTime endTime;

    /**
     * 接口请求消耗时间-毫秒
     */
    private Integer usedTimeMillis;

    /**
     * skyWalking的TraceId
     */
    private String skyWalkingTid;
    
    /**
     * 小程序appid.
     */
    private String miniAppid;

    /**
     * 小程序名称.
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * className+methodName
     */
    @TableField(exist = false)
    private String requestApi;

}
