package com.rocogz.syy.infrastructure.entity.prefecture;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-专区区域对应表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-03-27
 */
@TableName("basic_prefecture_area")
@Data
@EqualsAndHashCode(callSuper = false)
public class PrefectureArea extends IdEntity {

    private static final long serialVersionUID = -8650685506832376501L;
    /**
     * 专区编码
     */
    @NotBlank
    private String prefectureCode;

    /**
     * 省份
     */
    @NotBlank
    private String province;

    /**
     * 省份编码
     */
    @NotBlank
    private String provinceCode;

    /**
     * 城市
     */
    @NotBlank
    private String city;

    /**
     * 城市编码
     */
    @NotBlank
    private String cityCode;

    /**
     * 区/镇
     */
    @NotBlank
    private String district;

    /**
     * 区/镇编码
     */
    @NotBlank
    private String districtCode;

    /**
     * 街道
     */
    @NotBlank
    private String street;

    /**
     * 街道编码
     */
    @NotBlank
    private String streetCode;

    /**
     * 创建时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 更新人
     */
    private Integer updateUser;
}
