package com.rocogz.syy.infrastructure.dto.userLog;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author dongjuntong
 * @date 2021/08/18
 */
@Data
@Accessors(chain = true)
public class UserLogSaveReq {
    /**
     * 用户id
     */
    @NotNull(message = "用户id不能为空")
    private Integer userId;

    /**
     *变更说明
     */
    @NotBlank(message = "变更说明不能为空")
    private String description;

    /**
     * 变更人
     */
    private Integer createUser;
}
