package com.rocogz.syy.infrastructure.entity.dict;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 城市车牌号前缀字典-商户小程序使用
 * </p>
 * @author zhangmin
 * @since 2020-04-13
 */
@Getter
@Setter
@TableName(value = "basic_dict_license_prefix")
public class DictLicensePrefix extends IdEntity {

    private static final long serialVersionUID=1L;

    public static DictLicensePrefix DEFAULT = new DictLicensePrefix();
    static {
        DEFAULT.setProvinceName("广东省");
        DEFAULT.setCityName("中山市");
        DEFAULT.setLicensePrefix("粤T");
    }
    /**
     * 省名
     */
    private String provinceName;

    /**
     * 市名
     */
    private String cityName;

    /**
     * 车牌前缀
     */
    private String licensePrefix;

}
