package com.rocogz.syy.infrastructure.entity.apiInfomation;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 接口信息表
 * </p>
 *
 * @author yinshihao
 * @since 2020-04-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "basic_api_information")
@JsonIgnoreProperties(ignoreUnknown = true)
public class ApiInformation extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * url
     */
    private String url;

    /**
     * 接口名称
     */
    private String name;

    /**
     * 接口所在服务的名称
     */
    private String serviceName;

    /**
     * 接口所在类的名称
     */
    private String className;

    /**
     * 接口所在类的路径
     */
    private String classPath;

    /**
     * 接口对应方法的名称
     */
    private String methodName;

    /**
     * 详细描述
     */
    private String description;

    /**
     * 接口参数信息
     */
    private String paramInformation;

    /**
     * 接口返回值信息
     */
    private String returnInformation;

    /**
     * 某一平台下该接口的状态
     */
    @TableField(exist = false)
    private String status;
}
