package com.rocogz.syy.infrastructure.entity.menu;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 菜单模板entity
 * @date：2021/11/23
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("basic_menu_template")
public class BasicMenuTemplate extends IdEntity {

    private static final long serialVersionUID = 586012665917963433L;

    /**
     * 编号
     */
    private String code;

    /**
     * 模板分类（字典常量：MENU_LIST_INFO_TEMPLATE_CATEGORY）
     */
    private String category;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 服务商编号
     */
    private String agentCode;

    /**
     * 用户编号
     */
    private String systemAdminUserCode;

    /**
    * 模板归属菜单
    */
    private String menuCode;
    
    /**
    * 模板字段类型：COMMON-通用、CUSTOM-定制
    */
    private String templateColumnType;

    /**
     * 搜索条件类型
     */
    private String templateSearchConditionType;

    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;

    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    /**
     * 服务商简称
     */
    @TableField(exist = false)
    private String agentAbbreviation;

    /**
     * 更新前的模板类型
     */
    @TableField(exist = false)
    private String preTemplateColumnType;

    /**
     * 更新前的搜索条件类型
     */
    @TableField(exist = false)
    private String preTemplateSearchConditionType;

    /**
     * 显示字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> columns;

    /**
     * 更新前的定制列
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> preColumns;

    /**
     * 更新前的导出字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> preExportColumns;

    /**
     * 导出字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> exportColumns;

    /**
     * 搜索条件
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> searchColumns;

    /**
     * 更新前的搜索条件
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> preSearchColumns;
}