package com.rocogz.syy.infrastructure.dto.sms;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.HashMap;

/**
 * <dl>
 * <dd>Description: SmsWithTemplateParamDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/1/11 16:01</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
public class SmsWithTemplateParamDto {
    /**
     * 手机号码.
     */
    @NotBlank(message = "手机号不能为空")
    @Length(max = 11,min = 11, message = "手机号长度错误")
    String mobile;

    /**
     * 阿里云短信息模板编号.
     */
    @NotBlank(message = "阿里云短信息模板编号")
    String templateCode;

    /**
     * 外部流水号.
     */
    String outId;

    /**
     * 短信模板参数Map.
     */
    HashMap<String, String> templateParamMap;

    /**
     * 短信签名参数(为空时会默认使用配置文件里的签名).
     */
    String signName;
}
