package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 基础服务-发放主体账号实名认证申请
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-06-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "basic_admin_user_real_name_authentication")
public class AdminUserRealNameAuthentication extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * code
     */
    private String code;

    /**
     * admin user id
     */
    private Integer adminUserId;

    /**
     * admin username
     */
    private String adminUsername;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 员工号
     */
    private String employeeNo;

    /**
     * 所在部门
     */
    private String department;

    /**
     * 认证时所属发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 认证时所属发放主体名称
     */
    private String issuingBodyName;

    /**
     * 保险公司名称
     */
    private String companyName;

    /**
     * 身份证正面图片
     */
    private String frontImgPath;

    /**
     * 身份证反面图片
     */
    private String backImgPath;

    /**
     * 状态(待审核/审核通过/审核不通过)
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 实名认证申请时的 微信openid
     */
    private String wxOpenid;

    /**
     * 发放主体的所属代理商编码
     */
    private String agentCode;
}
