package com.rocogz.syy.infrastructure.entity.mchConfig;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 基础服务-微信收款商户配置信息表
 * </p>
 *
 * @author luoyc
 * @since 2021-01-04
 */
@Data
@Accessors(chain = true)
@TableName("basic_wx_payment_mch_config")
public class BasicWxPaymentMchConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款商户id
     */
    private String mchId;

    /**
     * 收款商户名称
     */
    private String mchName;

    /**
     * 收款商户Key
     */
    private String mchKey;

    /**
     * 证书文件路径(退款接口才会用到)
     */
    private String keyPath;

    /**
     * 支付成功回调地址(例：http://rocoautoserintfc-test.rocogz.com/api/roco/free/pay/wx/notify/order)
     */
    private String notifyUrl;

    /**
     * 退款成功回调地址(例：http://rocoautoserintfc-test.rocogz.com/api/roco/free/pay/wx/notify/refund)
     */
    private String refundNotifyUrl;

    /**
     * 支付方式(JSAPI--JSAPI支付（或小程序支付）、NATIVE--Native支付、APP--app支付，MWEB--H5支付)
     */
    private String tradeType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer size = 10;

}
