package com.rocogz.syy.infrastructure.entity.menu;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 菜单模板显示字段及搜索条件entity
 * @date：2022/04/21
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("basic_menu_template_column")
public class BasicMenuTemplateColumn extends IdEntity {

    private static final long serialVersionUID = 927758698266793936L;

    /**
    * 模板code
    */
    private String templateCode;

    /**
     * 模板类别（字典常量：MENU_TEMPLATE_CATEGORY）
     */
    private String templateCategory;

    /**
     * 字段归属菜单：BATCH_DISTRIBUTION_DETAIL-发券清单查询
     */
    private String menuCode;

    /**
     * 字段类型：COMMON-通用、CUSTOM-定制
     */
    private String columnType;

    /**
     * 字段code
     */
    private String columnCode;

    /**
     * 字段类别：VIEW-显示字段、SEARCH-搜索字段、EXPORT-导出字段
     */
    private String columnCategory;

    /**
     * 字段名
     */
    private String columnName;

    /**
     * 是否默认展示
     */
    private String isShow;

    /**
     * 字段key
     */
    private String columnKey;

    /**
    * 排序值
    */
    private Integer sortNum;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;

    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;
}