package com.rocogz.syy.infrastructure.dto.datapermission.miniAppPerfecture;

import com.rocogz.syy.infrastructure.constant.InfrastructureConstant;
import com.rocogz.syy.infrastructure.dto.datapermission.DtreeCheckArr;
import com.rocogz.syy.infrastructure.entity.app.config.BasicWxMiniAppConfig;
import com.rocogz.syy.infrastructure.entity.prefecture.Prefecture;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description:用户数据权限的平台和专区的树 </dd>
 * <dd>@date: 2021/06/03</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class DPMiniAppPrefectureTreeDto  {

    private static final long serialVersionUID = 4307848078425771330L;

    public DPMiniAppPrefectureTreeDto(){

        spread=true;
    }
    /**
     * 可以认为就是code
     */
    private String id;

    /**
     * 级别
     */
    private Integer level;
    /**
     * 标题
     */
    private String title;

    /**
     * 是否展开
     */
    private Boolean spread;
    /**
     * 是否选中
     */
    private Boolean checked;
    /**
     * 孩子
     */
    private List<DPMiniAppPrefectureTreeDto> children;

    /**
     * 小程序的APPID
     */
    private String miniAppid;

    /**
     * 如果类型是MINIAppConfig 则这个有值
     */
    private BasicWxMiniAppConfig wxMiniAppConfig;

    /**
     * 数据权限的类型，基础信息里面的 专区和MIN的标示
     * @see InfrastructureConstant.DictData#USER_DATA_PERMISSION_MINI_APP
     */
    private String dataType;
    /**
     * 编码
     */
    private String code;
    /**
     * 状态
     */
    private String status;

    /**
     * 复选框都要有这个
     */
    private DtreeCheckArr checkArr = new DtreeCheckArr();

}
