package com.rocogz.syy.infrastructure.dto.team;

import lombok.Data;

import static com.rocogz.syy.infrastructure.constant.InfrastructureConstant.IssuingBodyUserType;

/**
 * 车主端我的团队统计页面
 * @author djt
 * @date 2021/5/24
 */
@Data
public class TeamStatisticsDTO {

    /**
     * 用户类型
     * @see IssuingBodyUserType
     */
    private String userType;

    /**
     * 所属团队名称（当账户身份是团队管理员或者普通个人的时候有值）
     */
    private String teamName;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 团队数量
     */
    private Integer teamCount;

    /**
     * 团员数量
     */
    private Integer teamUserCount;

    /**
     * 是否有团队
     */
    private Boolean hasTeam;

    /**
     * 团队长名称
     */
    private String  teamLeader;

}
