package com.rocogz.syy.infrastructure.entity.menu;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 菜单列表信息及搜索条件定制列操作记录entity
 * @date：2022/04/21
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("basic_menu_template_operation_log")
public class BasicMenuTemplateOperationLog extends IdEntity {

    private static final long serialVersionUID = -94636285770096130L;

    /**
    * 模板编码
    */
    private String templateCode;
    
    /**
    * 操作项
    */
    private String operationItem;
    
    /**
    * 操作内容
    */
    private String operationContent;
    
    /**
    * 操作人
    */
    private String operator;
    
    /**
    * 操作时间
    */
    private LocalDateTime operationTime;
}