package com.rocogz.syy.infrastructure.dto.system.adminuser;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 发放主体账号小程序配置请求类
 * @author djt
 * @date 2022/5/12
 */
@Data
public class IssuingBodyUserMiniAppConfigReq {

    /**
     * 账号id
     */
    @NotNull
    private Integer userId;

    /**
     * 小程序角色
     */
    @NotEmpty
    private List<Integer> roleIds;

    /**
     *  B端小程序是否展示我的额度
     */
    @NotBlank
    private String personalAcctDisplaySwitch;

    /**
     *  B端小程序是否展示发放主体额度
     */
    @NotBlank
    private String issuingAcctDisplaySwitch;

    /**
     *
     *  B端小程序默认展示tab
     */
    @NotBlank
    private String miniAppDefaultTab;

    /**
     * 创建人
     */
    private Integer createUser;

}
