package com.rocogz.syy.infrastructure.entity.mchConfig;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 基础服务-微信收款商户配置信息表
 * </p>
 *
 * @author luoyc
 * @since 2021-01-04
 */
@Data
@Accessors(chain = true)
@TableName("basic_wx_payment_mch_config")
public class BasicWxPaymentMchConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款商户id
     */
    private String mchId;

    /**
     * 收款商户名称
     */
    private String mchName;

    /**
     * 收款商户Key
     * 云卓全景加密密钥(用途:接入商用于业务数据加密)
     */
    private String mchKey;

    /**
     * 证书文件路径(退款接口才会用到)
     */
    private String keyPath;

    /**
     * 支付成功回调地址(例：http://rocoautoserintfc-test.rocogz.com/api/roco/free/pay/wx/notify/order)
     */
    private String notifyUrl;

    /**
     * 退款成功回调地址(例：http://rocoautoserintfc-test.rocogz.com/api/roco/free/pay/wx/notify/refund)
     */
    private String refundNotifyUrl;

    /**
     * 支付方式(JSAPI--JSAPI支付（或小程序支付）、NATIVE--Native支付、APP--app支付，MWEB--H5支付)
     */
    private String tradeType;

    /**
     * 商户类型(TENPAY--财付通、PLUTUSPAY--云卓全景)
     */
    private String merchantType;

    /*-------------------云卓全景支付商相关-start-------------------*/

    /**
     * 支付商户设备号
     */
    private String sn;

    /**
     * 开发者账号
     */
    private String devId;

    /**
     * 接入商公钥（用途：提供给云卓进行接收数据后验签）
     */
    private String publicKey;

    /**
     * 服务商加密密钥(用途:接入商用于业务数据加密)
     * 目前主要对接了云卓全景
     */
    private String servicePublicKey;

    /**
     * 接入商私钥（用途：接入商用于业务数据签名）
     */
    private String privateKey;

    /*-------------------云卓全景支付商相关-end-------------------*/

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer size = 10;

}
