package com.rocogz.syy.infrastructure.dto.datapermission.team;

import com.rocogz.syy.infrastructure.dto.datapermission.DtreeCheckArr;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description:数据权限团队的树,前台使用了dtree构建树 </dd>
 * <dd>@date: 2021/06/04</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class DPTeamTreeDto {

    private static final long serialVersionUID = 4307848078425771330L;

    public DPTeamTreeDto(){
        spread =true;
    }
    /**
     * 可以认为就是code和数据权限中的data_type的组合
     */
    private String id;
    /**
     * 级别
     */
    private Integer level;
    /**
     * 标题
     */
    private String title;

    /**
     * 是否展开
     */
    private Boolean spread;

    /**
     * 节点的状态状态，看是否启用，前台没启用的会变颜色
     */
    private String status;

    /**
     * 孩子
     */
    private List<DPTeamTreeDto> children;

    /**
     * Dtree必须的
     */
    private DtreeCheckArr checkArr = new DtreeCheckArr();

    /**
     * 团队的Code
     */
    private String code;
    /**
     * 团队所属的数据权限类型
     */
    private String dataType;


}
