package com.rocogz.syy.infrastructure.entity.app.config;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-小程序配置 底部导航表
 * </p>
 *
 * @author zjk
 * @since 2023-2-5 14:45:53
 */
@Data
@Accessors(chain = true)
@TableName("basic_wx_mini_app_config_navi")
public class BasicWxMiniAppConfigNavi extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 服务平台编码
     */
    private String servicePlatformCode;

    /**
     * 导航 名称
     */
    private String name;

    /**
     * 编码（字典值的编码）
     */
    private String code;

    /**
     * 排序值
     */
    private Integer seq;

    /**
     * 图标
     */
    private String icon;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer limit = 10;



}
