package com.rocogz.syy.infrastructure.entity.issuingbodyrole;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 发放主体关联角色
 * </p>
 *
 * @author yinshihao
 * @since 2021-02-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class BasicIssuingBodyRole extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 来源（主体）编号
     */
    private String sourceCode;

    /**
     * 角色id
     */
    private Integer roleId;

    /**
     * 角色名称
     */
    @TableField(exist = false)
    private String roleName;
}
