package com.rocogz.syy.infrastructure.entity.app.config;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.infrastructure.entity.systemRun.BasicSystemRunManage;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 基础服务-小程序配置信息表
 * </p>
 *
 * @author luoyc
 * @since 2020-12-29
 */
@Data
@Accessors(chain = true)
@TableName("basic_wx_mini_app_config")
public class BasicWxMiniAppConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 服务平台编码
     */
    private String servicePlatformCode;

    /**
     * 服务平台名称
     */
    private String servicePlatformName;

    /**
     * 【代理人】端开启情况
     */
    private String bizStatus;

    /**
     * 平台状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 平台类型
     */
    private String servicePlatformType;

    /**
     * mini_appid
     */
    private String miniAppid;

    /**
     * 小程序名称
     */
    private String appName;

    /**
     * 密钥
     */
    private String secret;

    /**
     * token
     */
    private String token;

    /**
     * aesKey
     */
    private String aesKey;

    /**
     * 消息数据格式
     */
    private String msgDataFormat;

    /**
     * 缓存位置: local、redis，默认local
     */
    private String location;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 归属类型
     */
    private String belongType;

    /**
     * 合作客户编号/代理商编号
     */
    private String customerCode;

    /**
     * 车主端积分模块显示/隐藏
     */
    private String pointShowStatus;

    /**
     * 车主端积分模块-积分类型
     */
    private String pointShowType;

    /**
     * 车主端积分模块-积分展示名称
     */
    private String pointShowName;

    /**
     * 小程序二维码url
     */
    private String miniAppQrUrl;

    /**
     * 车主端提现显示/隐藏
     */
    private String withdrawalsShowStatus;

    /**
     * 车主端提现手续费率显示/隐藏
     */
    private String withdrawalsFeeRateShowStatus;

    /**
     * 车主端 提现问卷功能
     */
    private String inverstWithdrawalsShowStatus;

    /**
     * 显示油品牌,多个品牌标签号用逗号分隔,可以不勾选油品牌标签
     * 存入的是字典表中的品牌标签code,例如：ML2022080300003
     * @see com.rocogz.syy.infrastructure.entity.dict.DictData#OIL_BRAND
     */
    private String oilBrand;

    /**
     *小程序领取说明链接
     */
    private String receiveExplainLink;
    /**
     *小程序领取说明编码（系统自动生成）
     */
    private String receiveExplainCode;
    /**
     *小程序领取说明图片
     */
    private String receiveExplainImage;
    /**
     *小程序logo图片
     */
    private String miniAppLogo;

    /**
     * 合作客户简称
     */
    @TableField(exist = false)
    private String customerName;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer limit = 10;

    /** 查询过滤需要的小程序 appid 列表，没有不过不过滤 */
    @TableField(exist = false)
    private List<String> appids;

    /** 需要过滤的数据列表串 */
    @TableField(exist = false)
    private String filterListStr;

    /** 需要过滤的数据类型 */
    @TableField(exist = false)
    private String systemRunType;

    /** 系统运行模式管理 */
    @TableField(exist = false)
    private BasicSystemRunManage basicSystemRunManage;
}
