package com.rocogz.syy.infrastructure.entity.prefecture;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-专区表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-03-27
 */
@Data
@TableName("basic_prefecture")
public class Prefecture extends IdEntity {

    private static final long serialVersionUID = 3411363957722392675L;
    /**
     * 父级专区编码,父级专区编码为0的为顶级区域
     */
    private String parentCode;

    /**
     * 专区编码
     */
    private String code;

    /**
     * 专区名称
     */
    private String name;

    /**
     * 状态
     */
    private String status;

    /**
     * 开通服务状态
     */
    private String openServiceStatus;

    /**
     * 专区说明
     */
    private String description;

    /**
     * 创建时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 更新人
     */
    private Integer updateUser;

    /**
     * 小程序appid.
     */
    private String miniAppid;

    /**
     * 小程序名称.
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 所属服务平台名称.
     */
    @TableField(exist = false)
    private String servicePlatformName;
}
