package com.rocogz.syy.infrastructure.entity.app.config;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 小程序版块配置内容数据源entity
 * @date：2023/06/13
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("basic_mini_app_section_config_content_source")
public class BasicMiniAppSectionConfigContentSource extends IdEntity {

    private static final long serialVersionUID = -67269137136686399L;

    /**
    * 编码
    */
    private String code;
    
    /**
    * 版块编号
    */
    private String sectionCode;
    
    /**
    * 通用名称
    */
    private String currencyName;
    
    /**
    * 平台展示名称
    */
    private String platformShowName;
    
    /**
    * 可见性（Y-显示、N-隐藏）
    */
    private String isShow;
    
    /**
    * 排序号
    */
    private Integer sort;
}