package com.rocogz.syy.infrastructure.entity.industryType;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.infrastructure.dto.industryType.BusinessTypeDto;
import com.rocogz.syy.infrastructure.dto.industryType.FeeTypeDto;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 行业类型 </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/3 11:29</dd>
 * <dd>@author：liujianbing/dd>
 * </dl>
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@Getter
@Setter
@TableName(value = "basic_industry_type")
@Accessors(chain = true)
public class IndustryType extends UserTimeEntity {
    private static final long serialVersionUID=1L;

    private String industryCode;

    private String industryName;

    private String status;

    @TableField(exist = false)
    private String businessNames;

    @TableField(exist = false)
    private String feeNames;

    @TableField(exist = false)
    private List<BusinessTypeDto> businessTypeList;

    @TableField(exist = false)
    private List<FeeTypeDto> feeTypeList;
}
