package com.rocogz.syy.infrastructure.dto.industryType;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * @author ljb
 * @date 2023/7/3
 */
@Data
@Accessors(chain = true)
public class IndustryTypeSearchReq {

    private Integer id;
    /**
     * 行业编码
     */
    private String industryCode;

    /**
     * 行业名称
     */
    private String industryName;

    /**
     * 状态
     */
    private String status;

    private Boolean exportFlag = false;

    private int page;

    private int limit;

    public Map<String, Object> toMap() {
        Map<String, Object> map = Maps.newHashMap();
        if (StringUtils.hasLength(this.industryCode)) {
            map.put("industryCode", "%" + this.industryCode + "%");
        }
        if (StringUtils.hasLength(this.industryName)) {
            map.put("industryName", "%" + this.industryName + "%");
        }
        if (StringUtils.hasLength(this.status)) {
            map.put("status", this.status);
        }

        return map;
    }
}
