package com.rocogz.syy.infrastructure.dto.menu.template;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.infrastructure.entity.menu.BasicMenuTemplateColumn;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 编辑通用模板字段dto
 * @date：2022/10/26
 * @author：huangdeyi
 */
@Data
public class EditCommonColumnReqDto {

    /**
     * 模板归属菜单
     */
    private String menuCode;

    /**
     * 模板分类（字典常量：MENU_LIST_INFO_TEMPLATE_CATEGORY）
     */
    private String category;

    /**
     * 显示字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> columns;

    /**
     * 更新前的显示字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> preColumns;

    /**
     * 导出字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> exportColumns;

    /**
     * 更新前的导出字段
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> preExportColumns;

    /**
     * 搜索条件
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> searchColumns;

    /**
     * 更新前的搜索条件
     */
    @TableField(exist = false)
    private List<BasicMenuTemplateColumn> preSearchColumns;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;
}
