package com.rocogz.syy.infrastructure.dto.industryType;

import com.google.common.collect.Maps;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @author ljb
 * @date 2023/7/3
 */
@Data
@Accessors(chain = true)
public class BusinessTypeSearchReq {

    private Integer id;
    /**
     * 业务编码
     */
    private String businessCode;

    /**
     * 业务名称
     */
    private String businessName;

    /**
     * 行业id
     */
    private Integer industryId;

    /**
     * 行业编码
     */
    private String industryCode;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 状态
     */
    private String status;

    private List<Integer> excludeIds;

    private List<String> excludeCodes;

    private List<String> includeCodes;

    private int page;

    private int limit;

    public Map<String, Object> toMap() {
        Map<String, Object> map = Maps.newHashMap();
        if (this.industryId != null && this.industryId > 0) {
            map.put("industryId", this.industryId);
        }
        if (StringUtils.hasLength(this.industryCode)) {
            map.put("industryCode", this.industryCode);
        }
        if (StringUtils.hasLength(this.businessCode)) {
            map.put("businessCode",this.businessCode);
        }
        if (StringUtils.hasLength(this.issuingBodyCode)) {
            map.put("issuingBodyCode",this.issuingBodyCode);
        }
        if (StringUtils.hasLength(this.businessName)) {
            map.put("businessName", "%" + this.businessName + "%");
        }
        if (StringUtils.hasLength(this.status)) {
            map.put("status", this.status);
        }
        if(CollectionUtils.isNotEmpty(excludeIds)) {
            map.put("excludeIds",excludeIds);
        }
        if(CollectionUtils.isNotEmpty(excludeCodes)) {
            map.put("excludeCodes",excludeCodes);
        }
        if(CollectionUtils.isNotEmpty(includeCodes)) {
            map.put("includeCodes",includeCodes);
        }
        return map;
    }

}
