package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.collect.Lists;
import com.rocogz.syy.common.entity.Account;
import com.rocogz.syy.infrastructure.constant.InfrastructureConstant;
import com.rocogz.syy.infrastructure.entity.mini.app.BasicMiniAppRole;
import com.rocogz.syy.infrastructure.entity.permission.Permission;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.entity.role.Role;
import com.rocogz.syy.infrastructure.enumerate.UserCreateChannelEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;


/**
 * <p>
 * 管理员账号表
 * </p>
 *
 * @author liangyongtong
 * @since 2020-01-14
 */
@SuppressWarnings("all")
@TableName(value = "basic_system_admin_user")
public class AdminUser extends Account {

    private static final long serialVersionUID = 1L;

    public AdminUser() {
    }

    public AdminUser(Integer id) {
        this.id = id;
    }


    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 状态
     */
    private String status;


    /**
     * 是否需要激活验证
     */
    private String registerTag;

    /**
     * 激活状态
     */
    private String registerStatus;

    /**
     * 激活时间
     */
    private LocalDateTime registerTime;

    /**
     * 检索字段
     */
    private String keyword;

    /**
     * 是否删除
     */
    private Boolean deleted;

    /**
     * 所属角色
     */
    private transient List<Role> roles;

    /**
     * 小程序角色
     */
    private transient List<BasicMiniAppRole> miniAppUserRoles;


    /**
     * 是否已激活 Y/N
     */
    private String active;

    /**
     * 是否更新过初始密码 Y/N
     */
    private String uppass;

    /**
     * 角色id集合  (用于接收前端传过来的角色id)
     */
    private transient List<Integer> roleId;

    /**
     * 用户数据权限
     */
    private transient List<UserDataPermission> userDataPermissions;

    /**
     * 所属项目编码
     */
    private String systemCode;

    /**
     * 用户来源
     *
     * @see UserCreateChannelEnum
     */
    private String srcChannel;

    /**
     * 内置用户标识位  周展锆ADD
     *
     * @see UserCreateChannelEnum
     */
    private String builtIn;

    /**
     * 激活码
     */
    private String cipher;

    /**
     * 最后登录时间
     */
    private LocalDateTime lastLoginTime;

    /**
     * B端最后登录时间
     */
    private LocalDateTime agentBLastLoginTime;

    /**
     * 允许PC端登录 Y/N
     */
    private String allowPcLogin;

    /**
     * 允许小程序端登录（B端)
     */
    private String allowMiniAppLogin;

    /**
     * 数据权限类型：
     * 在浙商项目机构账号管理多了个数据权限的选择
     * 主体本级 / 主体本级及下级  仅限个人
     */
    private String dpType;


    @TableField(exist = false)
    private String teamName;

    /**
     * 团队编号
     */
    @TableField(exist = false)
    private String teamCode;

    /**
     * 角色名称
     */
    @TableField(exist = false)
    private String roleNames;


    /**
     * 车服后台管理用户信息
     */
    @TableField(exist = false)
    private AdminUserInfo adminUserInfo;

    public List<UserDataPermission> getUserDataPermissions() {
        return userDataPermissions;
    }

    public void setUserDataPermissions(List<UserDataPermission> userDataPermissions) {
        this.userDataPermissions = userDataPermissions;
    }


    public List<Integer> getRoleId() {
        return roleId;
    }

    public void setRoleId(List<Integer> roleId) {
        this.roleId = roleId;
    }

    /**
     * 获取用户角色名称
     *
     * @return
     */
    public List<String> getRoleNameList() {
        if (CollectionUtils.isEmpty(roles)) {
            return Collections.emptyList();
        }

        ArrayList<String> roleNames = Lists.newArrayListWithCapacity(roles.size());
        for (Role role : roles) {
            roleNames.add(role.getName());
        }

        return roleNames;
    }


    /**
     * 获取用户角色名称
     *
     * @return
     */
    public List<String> getMiniRoleNameList() {
        if (CollectionUtils.isEmpty(miniAppUserRoles)) {
            return Collections.emptyList();
        }

        ArrayList<String> roleNames = Lists.newArrayListWithCapacity(miniAppUserRoles.size());
        for (BasicMiniAppRole role : miniAppUserRoles) {
            roleNames.add(role.getName());
        }

        return roleNames;
    }



    /**
     * 获取用户权限
     *
     * @return
     */
    public LinkedHashSet<String> getPermissions() {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(roles)) {
            for (Role role : roles) {
                List<Permission> permissionList = role.getPermission();
                if (permissionList != null) {
                    for (Permission perm : permissionList) {
                        if (!StringUtils.isEmpty(perm.getViewPermission())) {
                            permissions.add(perm.getViewPermission());
                        }

                        if (!StringUtils.isEmpty(perm.getUrlPermission())) {
                            permissions.add(perm.getUrlPermission());
                        }
                    }
                }
            }
        }
        return permissions;
    }


    /**
     * 是否是单手机号多账号模式
     *
     * @return
     */
    public boolean oneMobileToManyAccount() {
        if (InfrastructureConstant.SourceSystemType.ADMIN.equals(this.systemCode)) {
            if (InfrastructureConstant.DictUserType.SERVICE.equals(this.getType())) {
                return true;
            }
            if (InfrastructureConstant.DictUserType.PLATFORM.equals(this.getType())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<Role> getRoles() {
        return roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public String getActive() {
        return active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getUppass() {
        return uppass;
    }

    public void setUppass(String uppass) {
        this.uppass = uppass;
    }


    public String getRegisterTag() {
        return registerTag;
    }

    public void setRegisterTag(String registerTag) {
        this.registerTag = registerTag;
    }

    public String getRegisterStatus() {
        return registerStatus;
    }

    public void setRegisterStatus(String registerStatus) {
        this.registerStatus = registerStatus;
    }

    public LocalDateTime getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(LocalDateTime registerTime) {
        this.registerTime = registerTime;
    }

    public String getSystemCode() {
        return systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public AdminUserInfo getAdminUserInfo() {
        return adminUserInfo;
    }

    public void setAdminUserInfo(AdminUserInfo adminUserInfo) {
        this.adminUserInfo = adminUserInfo;
    }

    public String getSrcChannel() {
        return srcChannel;
    }

    public void setSrcChannel(String srcChannel) {
        this.srcChannel = srcChannel;
    }


    public String getCipher() {
        return cipher;
    }

    public void setCipher(String cipher) {
        this.cipher = cipher;
    }

    public LocalDateTime getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(LocalDateTime lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public LocalDateTime getAgentBLastLoginTime() {
        return agentBLastLoginTime;
    }

    public void setAgentBLastLoginTime(LocalDateTime agentBLastLoginTime) {
        this.agentBLastLoginTime = agentBLastLoginTime;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getRoleNames() {
        return roleNames;
    }

    public void setRoleNames(String roleNames) {
        this.roleNames = roleNames;
    }

    public String getBuiltIn() {
        return builtIn;
    }

    public void setBuiltIn(String builtIn) {
        this.roleNames = builtIn;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public String getAllowPcLogin() {
        return allowPcLogin;
    }

    public void setAllowPcLogin(String allowPcLogin) {
        this.allowPcLogin = allowPcLogin;
    }

    public String getAllowMiniAppLogin() {
        return allowMiniAppLogin;
    }

    public void setAllowMiniAppLogin(String allowMiniAppLogin) {
        this.allowMiniAppLogin = allowMiniAppLogin;
    }

    public String getDpType() {return dpType; }

    public void setDpType(String dpType) { this.dpType = dpType; }

    public List<BasicMiniAppRole> getMiniAppUserRoles() {
        return miniAppUserRoles;
    }

    public void setMiniAppUserRoles(List<BasicMiniAppRole> miniAppUserRoles) {
        this.miniAppUserRoles = miniAppUserRoles;
    }
}
