package com.rocogz.syy.infrastructure.entity.app.config;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 小程序版块配置内容entity
 * @date：2023/06/13
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("basic_mini_app_section_config_content")
public class BasicMiniAppSectionConfigContent extends IdEntity {

    private static final long serialVersionUID = 463260824593199388L;

    /**
    * 编码
    */
    private String contentCode;
    
    /**
    * 平台展示名称
    */
    private String platformShowName;
    
    /**
    * 可见性（Y-显示、N-隐藏）
    */
    private String isShow;
    
    /**
    * 排序号
    */
    private Integer sort;
    
    /**
    * 版块code
    */
    private String sectionCode;

    /**
     * 所属平台miniAppid
     */
    private String miniAppid;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 通用名称
     */
    @TableField(exist = false)
    private String currencyName;
}