package com.rocogz.syy.infrastructure.entity.dict;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.VersionEntity;
import com.rocogz.syy.infrastructure.enumerate.DictTypeCatalogEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 字典类型表 </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/1/8 13:39</dd>
 * <dd>@author：尹世豪/dd>
 * </dl>
 */
@Getter
@Setter
@TableName(value = "basic_dict_type")
public class DictType extends VersionEntity {

    private static final long serialVersionUID=1L;

    private String code;

    private String name;

    /**
     * OPEN 启用/LOCK 停用
     */
    private String status;

    /**
     * 字典数据分类
     */
    private DictTypeCatalogEnum  cate;

    @TableField(exist = false)
    private List<DictData> dataList;

}
