package com.rocogz.syy.infrastructure.entity.log;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-接口请求日志
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-07-20
 */
@Data
@Accessors(chain = true)
public class EsApiRequestLog {

    private static final long serialVersionUID = -5868362862266868024L;

    /**
     * 当前接口请求用户的编号
     */
    @JsonProperty("current_user_code")
    private String currentUserCode;

    /**
     * 当前接口请求用户的openid
     */
    @JsonProperty("current_user_openid")
    private String currentUserOpenid;

    /**
     * 当前接口请求用户的手机号
     */
    @JsonProperty("current_user_mobile")
    private String currentUserMobile;

    /**
     * 接口类名称
     */
    @JsonProperty("class_name")
    private String className;

    /**
     * 接口方法
     */
    @JsonProperty("method_name")
    private String methodName;

    /**
     * 请求类型
     */
    @JsonProperty("request_type")
    private String requestType;

    /**
     * 请求url
     */
    @JsonProperty("request_url")
    private String requestUrl;

    /**
     * 请求参数
     */
    @JsonProperty("request_params")
    private String requestParams;

    /**
     * 响应数据
     */
    @JsonProperty("response")
    private String response;

    /**
     * 请求开始时间
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone = "GMT+08:00")
    private LocalDateTime startTime;

    /**
     * 请求结束时间
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone = "GMT+08:00")
    private LocalDateTime endTime;

    /**
     * 接口请求消耗时间-毫秒
     */
    @JsonProperty("used_time_millis")
    private Integer usedTimeMillis;

    /**
     * skyWalking的TraceId
     */
    @JsonProperty("sky_walking_tid")
    private String skyWalkingTid;
    
    /**
     * 小程序appid.
     */
    @JsonProperty("mini_appid")
    private String miniAppid;

    /**
     * 冗余字段-用于分组统计.
     */
    @JsonProperty("request_api_and_url")
    private String requestApiAndUrl;
}
