package com.rocogz.syy.infrastructure.entity.systemRun;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-系统运行模式管理日志
 * </p>
 *
 * @author luoyc
 * @since 2021-02-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class BasicSystemRunManageLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 运行模式管理id
     */
    private Integer manageId;

    /**
     * 维护级别 NORMAL
     */
    private String maintainType;

    /**
     * 系统运行类型 NORMAL、UPGRADE
     */
    private String systemRunType;

    /**
     * 系统升级类别
     */
    private String systemUpgradeType;

    /**
     * 公告内容
     */
    private String content;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer size = 10;


}
