package com.rocogz.syy.infrastructure.entity.wechat;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/29 10:53</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@TableName(value = "basic_wechat_open_admin_user")
public class WechatOpenAdminUser extends IdEntity {
    /**
     * 微信openid
     */
    private String openId;

    /**
     * 账号名
     */
    private String acctName;

    /**
     * 手机号-页面展示
     */
    private String mobile;

    /**
     * 姓名-页面展示
     */
    private String name;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime createTime;

    /**
     * 最后更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime updateTime;

    /**
     * 所属项目编码
     */
    private String systemCode;

    /**
     * 发放主体编号
     */
    @TableField(exist = false)
    private String issuingBodyCode;

    /**
     * 代理商编号
     */
    @TableField(exist = false)
    private String agentCode;

    /**
     * 代理商名称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 激活状态
     */
    @TableField(exist = false)
    private String registerStatus;


    /**
     * 是否允许PC登录 basic_system_admin_user 中
     */
    @TableField(exist = false)
    private String allowPcLogin;


    /**
     * 是否允许B端登录 取得是 basic_system_admin_user 中
     */
    @TableField(exist = false)
    private String allowMiniAppLogin;


}