package com.rocogz.syy.infrastructure.constant;

/**
 * <dl>
 * <dd>Description: 基础服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/20 11:43</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class InfrastructureConstant {
    private InfrastructureConstant(){}

    /**
     * 选择区域为全部时的编码
     */
    public static final String AREA_ALL_CODE = "AREA_ALL";

    public static final String MQ_EXCHANGE_NAME = "INFRASTRUCTURE_EXCHANGE";
    public static final String MQ_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_API_REQUEST_LOG";

    public static final String MQ_MALL_API_REQUEST_LOG_ROUTE_KEY = "MALL_API_REQUEST_LOG_KEY";
    public static final String MQ_MALL_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_MALL_API_REQUEST_LOG_QUEUE";

    public static final String MQ_MERCHANT_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_MERCHANT_API_REQUEST_LOG_QUEUE";
    public static final String MQ_MERCHANT_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_MERCHANT_API_REQUEST_LOG_KEY";

    public static final String MQ_AGENT_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_AGENT_API_REQUEST_LOG_QUEUE";
    public static final String MQ_AGENT_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_AGENT_API_REQUEST_LOG_KEY";

    /** 系统运行信息缓存Key */
    public static final String SYSTEM_RUN_MANAGE_NEW_REDIS_KEY_PREFIX = "SYSTEM_RUN_MANAGE_NEW_REDIS_KEY:";

    /** 小程序配置信息缓存Key */
    public static final String SYSTEM_APP_INFO_REDIS_KEY_PREFIX = "SYSTEM_APP_INFO_REDIS_KEY:";

    /** 服务平台导航信息缓存Key */
    public static final String SYSTEM_APP_NAVI_REDIS_KEY_PREFIX = "SYSTEM_APP_NAVI_REDIS_KEY:";

    /** 菜单模板类型-通用*/
    public static final String MENU_TEMPLATE_COMMON = "COMMON";
    /** 菜单模板类型-定制*/
    public static final String MENU_TEMPLATE_CUSTOM = "CUSTOM";
    /** 菜单模板字段类型-显示字段*/
    public static final String MENU_TEMPLATE_COLUMN_VIEW = "VIEW";
    /** 菜单模板类型-查询条件*/
    public static final String MENU_TEMPLATE_COLUMN_SEARCH = "SEARCH";
    /** 菜单模板类型-导出字段*/
    public static final String MENU_TEMPLATE_COLUMN_EXPORT = "EXPORT";

    /**
     * 公共的状态 启用
     */
    public final static String COMMON_STATUS_OPEN = "OPEN";
    /**
     * 公共的状态 停用
     */
    public final static String COMMON_STATUS_LOCK = "LOCK";
    /**
     * 公共的状态 是
     */
    public final static String COMMON_STATUS_YES = "Y";
    /**
     * 公共的状态 否
     */
    public final static String COMMON_STATUS_NO = "N";


    /**
     * 字典表类型
     */
    public class DictType {
        public final static String USER_DATA_PERMISSION_TYPE = "USER_DATA_PERMISSION_TYPE";
        public final static String SERVICE_INVALID_UNRECEIVE_TYPE = "SERVICE_INVALID_UNRECEIVE_TYPE"; //服务商过期未领取
    }

    /**
     * 字典表数据
     */
    public class DictData {

        /** 供应商，与用户权限表中data_type对应*/
        public final static String USER_DATA_PERMISSION_SUPPLIER = "SUPPLIER";
        public final static String USER_DATA_PERMISSION_SUPPLIER_LABEL = "供应商";

        /** 专区 */
        public final static String USER_DATA_PERMISSION_PREFECTURE = "PREFECTURE";
        public final static String USER_DATA_PERMISSION_PREFECTURE_LABEL = "专区";

        /** 平台商户 */
        public final static String USER_DATA_PERMISSION_ISSUING_BUSINESS = "ISSUING_BUSINESS";
        public final static String USER_DATA_PERMISSION_ISSUING_BUSINESS_LABEL = "发放主体-平台商户";

        /**
         * 发放机构
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ORG = "ISSUING_ORG";
        public final static String USER_DATA_PERMISSION_ISSUING_ORG_LABEL = "发放主体-发放机构";

        /**
         * 合作企业
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ENTERPRISE = "ISSUING_ENTERPRISE";
        public final static String USER_DATA_PERMISSION_ISSUING_ENTERPRISE_LABEL = "发放主体-合作企业";


        /**
         * 代理公司
         */
        public final static String USER_DATA_PERMISSION_ISSUING_AGENT_COMPANY = "ISSUING_AGENT_COMPANY";
        public final static String USER_DATA_PERMISSION_ISSUING_AGENT_COMPANY_LABEL = "发放主体-代理公司";

        /**
         * 4S店
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ISSUING_CAR_SALE_SERVICE = "ISSUING_CAR_SALE_SERVICE";
        public final static String USER_DATA_PERMISSION_ISSUING_ISSUING_CAR_SALE_SERVICE_LABEL = "发放主体-4S店";


        /**
         * 结算主体
         */
        public final static String USER_DATA_PERMISSION_SETTLE_SUBJECT = "SETTLE_SUBJECT";
        public final static String USER_DATA_PERMISSION_SETTLE_SUBJECT_LABEL = "结算主体";

        /**
         * 小程序
         */
        public final static String USER_DATA_PERMISSION_MINI_APP = "MINI_APP";
        public final static String USER_DATA_PERMISSION_MINI_APP_LABEL = "所属平台";

        /**
         * 团队
         */
        public final static String USER_DATA_PERMISSION_TEAM="P_TEAM";
        public final static String USER_DATA_PERMISSION_TEAM_LABEL = "团队";

        /**
         * 个人
         */
        public final static String USER_DATA_PERMISSION_SELF="P_SELF";
        public final static String USER_DATA_PERMISSION_SELF_LABEL = "个人";
        //自身权限特定的Code
        public final static String USER_DATA_PERMISSION_SELF_CODE="SELF";

        /**
         * 代理商
         */
        public final static String USER_DATA_PERMISSION_AGENT="P_AGENT";
        public final static String USER_DATA_PERMISSION_AGENT_LABEL = "代理商";

        /**
         * 合作客户
         */
        public final static String USER_DATA_PERMISSION_CUSTOMER="P_CUSTOMER";
        public final static String USER_DATA_PERMISSION_CUSTOMER_LABEL = "合作客户";


        /** 供应商，与用户权限表中data_type对应*/
        public final static String USER_DATA_PERMISSION_GOODS_TYPE = "P_GOODS_TYPE";
        public final static String USER_DATA_PERMISSION_GOODS_TYPE_LABEL = "产品类别";


        //菜单定制
        public static final String MENU_TEMPLATE_BATCH_DISTRIBUTION_DETAIL = "BATCH_DISTRIBUTION_DETAIL"; // 发券清单查询菜单


        /**
         * 菜单模板分类
         */
        //系统模板
        public static final String MENU_TEMPLATE_CATEGORY_SYSTEM = "SYSTEM";
        //服务商模板
        public static final String MENU_TEMPLATE_CATEGORY_AGENT = "AGENT";
        //发放主体模板
        public static final String MENU_TEMPLATE_CATEGORY_ISSUINGBODY = "ISSUINGBODY";
    }


    public  static class DictRoleType {
        public static final String TYPE_CODE = "ROLE_TYPE";
        // 系统角色
        public static final String SYS = "system";
        // 发放主体角色
        public static final String PLATFORM = "platform";
        // 集成商角色
        public static final String BIZ = "biz";
        // 服务商角色
        public static final String SERVICE = "service";
    }


    public  static class DictPlatformRoleScope {
        public static final String TYPE_CODE = "PLATFORM_ROLE_SCOPE";
        // 所有平台
        public static final String ALL = "ALL";
        // 指定平台
        public static final String SPECIAL = "SPECIAL";
    }

    public  static class DictUserType {
        public static final String TYPE_CODE = "USER_TYPE";
        // 系统用户
        public static final String SYS = "system";
        // 发放主体账号
        public static final String PLATFORM = "platform";
        // 集成商用户
        public static final String BIZ = "biz";
        // 服务商账号
        public static final String SERVICE = "service";
        // 供应商账号
        public static final String SUPPLIER = "supplier";
    }
    public static class IsType{

        public static final String N = "N";

        public static final String Y = "Y";
    }


    public  static class DictIssuingBodyRoleScope {
        public static final String TYPE_CODE = "ISSUING_BODY_ROLE_SCOPE";
        // 所有发放主体
        public static final String ALL = "ALL";
        // 指定发放主体
        public static final String SPECIAL = "SPECIAL";
    }



    /**
     * 来源系统
     */
    public static class SourceSystemType  {

        // 后台管理系统
        public static final String ADMIN = "ADMIN";

        // 分销系统
        public static final String DISTRIBUTION = "DISTRIBUTION";
    }

    /**
     * 维护级别
     */
    public static class MaintainType  {
        // 平台级
        public static final String PLATFORM = "PLATFORM";
    }

    /**
     * 系统运行类型
     */
    public static class SystemRunType  {

        // 正常运转模式
        public static final String NORMAL = "NORMAL";

        // 系统升级模式
        public static final String UPGRADE = "UPGRADE";
    }

    /**
     * 系统升级类别
     */
    public static class SystemUpgradeType  {

        // 正常升级
        public static final String NORMAL = "NORMAL";

        // Bug紧急处理
        public static final String BUG = "BUG";
    }

    /**
     * 团队身份
     */
    public static class TeamPositionType{

        /**
         * 团队长
         */
        public static final String LEADER = "LEADER";

        /**
         * 团员
         */
        public static final String MEMBER = "MEMBER";
    }



    /**
     * 发放主体账号性质
     */
    public static class IssuingBodyUserNatureType{

        /**
         * 常规账号
         */
        public static final String  NORMAL = "NORMAL";

        /**
         * 特殊账户
         */
        public static final String SPECIFIC = "SPECIFIC";
    }

    /**
     * 发放主体账号类型
     */
    public static class IssuingBodyUserType{

        public static final String TYPE_CODE = "ISSUING_BODY_USER_TYPE";

        /**
         * 普通个人账号
         */
        public static final String  NORMAL = "NORMAL";

        /**
         * 团队管理员
         */
        public static final String TEAM_LEADER = "TEAM_LEADER";

        /**
         * 机构管理员
         */
        public static final String ENTERPRISE_LEADER = "ENTERPRISE_LEADER";
    }


    /**
     * 发放主体角色类型
     */
    public static class IssuingBodyRoleType{

        public static final String TYPE_CODE = "ISSUING_BODY_ROLE_TYPE";

        /**
         * 普通个人账号
         */
        public static final String  NORMAL = "NORMAL";

        /**
         * 团队管理员
         */
        public static final String TEAM_LEADER = "TEAM_LEADER";

        /**
         * 机构管理员
         */
        public static final String ENTERPRISE_LEADER = "ENTERPRISE_LEADER";
    }

    /**
     * 后台聚合系统账号类型
     */
    public static class   AdminSystemUserType {
        public static final String TYPE_CODE = "ADMIN_SYSTEM_USER_TYPE";

        /**
         * 普通个人账号
         */
        public static final String  SYSTEM = "SYSTEM";

        /**
         * 团队管理员
         */
        public static final String AGENT = "AGENT";

    }

    /**
     * 后台聚合系统账号类型
     */
    public static class MiniAppConfigServicePlatformBelongType {
        public static final String TYPE_CODE = "SERVICE_PLATFORM_BELONG_TYPE";

        /**
         * 官方平台
         */
        public static final String SYSTEM = "SYSTEM";

        /**
         * 合作客户平台
         */
        public static final String CUSTOMER = "CUSTOMER";

        /**
         * 代理商平台
         */
        public static final String AGENT = "AGENT";

    }

    /**
     * 发放主体账号实名认证申请状态
     */
    public static class AdminUserRealNameAuthStatus {
        public static final String TYPE_CODE = "ADMIN_USER_REAL_NAME_AUTH_STATUS";

        /**
         * 待审核
         */
        public static final String PENDING_APPROVE = "PENDING_APPROVE";

        /**
         * 审核不通过
         */
        public static final String REFUSE = "REFUSE";

        /**
         * 审核通过
         */
        public static final String PASS = "PASS";

    }



    /**
     * 数据权限作用范围
     */
    public static class DPUseScopeType {

        /**
         * 本级
         */
        public static final String CURRENT = "CURRENT";

        /**
         * 本级及下级
         */
        public static final String CURRENT_CHILD = "CURRENT_CHILD";

    }

    /**
     * B端小程序默认展示tab
     */
    public static class MiniAppDefaultTab{

        public static final String TYPE_CODE = "MINI_APP_DEFAULT_TAB";

        /**
         *   我的礼赠记录
         */
        public static final String PERSONAL = "PERSONAL";

        /**
         *  当前主体礼赠记录
         */
        public static final String ISSUING_BODY = "ISSUING_BODY";
    }

    /**
     * 小程序默认展示的导航
     */
    public static class MiniAppDefaultNavi{

        public static final String PLATFORM_NAVI = "PLATFORM_NAVI";

        /**
         *   首页
         */
        public static final String SHOUYE = "SHOUYE";

        /**
         *  活动
         */
        public static final String HUODONG = "HUODONG";

        /**
         *  去加油
         */
        public static final String QUJIAYOU = "QUJIAYOU";

        /**
         *  订单
         */
        public static final String DINGDAN = "DINGDAN";

        /**
         *  我的
         */
        public static final String WODE = "WODE";
    }

    /**
     * 微信用户与发放主体账号绑定方式
     */
    public static class UserMiniAppInfoBindType {
        /**
         * 实名认证后绑定
         */
        public static final String REAL_NAME_AUTH = "REALNAMEAUTH";

        /**
         * 通过微信直接绑定
         */
        public static final String WX_BIND = "WXBIND";
    }


    /**
     * 积分转让类型
     */
    public static class PointTransferType {
        /**
         * 积分转让
         */
        public static final String TRANSFER = "TRANSFER";

        /**
         * 有奖问卷
         */
        public static final String INVESTIGATE = "INVESTIGATE";
    }

    /**
     * 域名 字段值
     */
    public static class DomainName{

        public static final String TYPE_CODE = "DOMAIN_NAME";

        /**
         *   短链接
         */
        public static final String SHORT_LINK = "SHORT_LINK";

    }

    public static final String BASIC_MINI_APP_RECEIVE_EXPLAIN_CODE_KEY_PREFIX = "BASIC:MINI_APP:RECEIVE_EXPLAIN_CODE:";


    /**
     * 小程序版块配置板块类型
     */
    public static class MiniAppSectionConfigType {

        /**
         * 我的卡券
         */
        public static final String MY_COUPON = "MY_COUPON";

        /**
         * 我的订单
         */
        public static final String MY_ORDER = "MY_ORDER";

        /**
         * 常用功能
         */
        public static final String FREQUENT_FUN = "FREQUENT_FUN";

        /**
         * 常用栏目配置
         */
        public static final String FREQUENT_COL = "FREQUENT_COL";

    }


    /**
     * 平台账号-机构账号（就是新做了个机构账号的菜单，还是原来的发放主体账号)
     */
    public static class platformOrgDpType {

        public static final String TYPE = "PLATFORM_ORG_DP_TYPE";

        /**
         * 发放主体本级下级
         */
        public static final String BODY_CURRENT = "BODY_CURRENT"; //本级
        public static final String BODY_CURRENT_CHILD = "BODY_CURRENT_CHILD"; //本级下级
        public static final String SELF = "SELF"; //仅限本人
    }

    /**
     * 清单模板对应的数据字典code
     */
    public static final String BASIC_MENU_COLUMN_DICT_TYPE = "BATCH_DISTRIBUTION_DETAIL_COLUMN";
    /**
     * 保司政策金额合计
     */
    public static final String INSURANCE_POLICY_TOTAL_AMOUNT_DICT_CODE = "INSURANCEPOLICYTOTALAMOUNT";
    /**
     * 现金赠送盈余金额
     */
    public static final String CASH_GIFT_SURPLUS_AMOUNT_DICT_CODE = "CASHGIFTSURPLUSAMOUNT";
    /**
     * 项目赠送成本红线金额
     */
    public static final String PROJECT_GIFT_COST_RED_LINE_AMOUNT_DICT_CODE = "PROJECTGIFTCOSTREDLINEAMOUNT";
    /**
     * 项目成本合计金额
     */
    public static final String TOTAL_PROJECT_COST_AMOUNT_DICT_CODE = "TOTALPROJECTCOSTAMOUNT";
    /**
     * 项目赠送盈余金额
     */
    public static final String PROJECT_GIFT_SURPLUS_AMOUNT_DICT_CODE = "PROJECTGIFTSURPLUSAMOUNT";
    /**
     * 店内总送积分
     */
    public static final String GIVE_TOTAL_POINT_AMOUNT_DICT_CODE = "GIVETOTALPOINTAMOUNT";


    //供应商账号 默认的后台角色Id
    public static class SystemSupplierUserDefaultConfig {

        public static final String TYPE = "SYS_SUPPLIER_USER_DEFAULT_CONIFG_TYPE";
        /**
         * 缺省角色
         */
        public static final String DEFAULT_ROLE = "DEFAULT_ROLE"; //缺省角色

    }


}
