package com.rocogz.syy.infrastructure.entity.menu;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.infrastructure.entity.industryType.IndustryType;
import lombok.Getter;
import lombok.Setter;

/**
 * 发放主体menu所关联绑定的行业
 *
 * @author hsf
 * @since 2020-09-01
 */
@Setter
@Getter
@TableName(value = "basic_custom_menu_industry")
public class CustomMenuIndustry extends IdEntity {

    /**
     * 发放主体menuId
     *
     * @see CustomMenu#id
     */
    private Integer customMenuId;

    /**
     * 关联的行业编号
     *
     * @see IndustryType#industryCode
     */
    private String industryCode;

    // 以下用来展示,非PO属性

    @TableField(exist = false)
    private  String industryName;


}