package com.rocogz.syy.infrastructure.entity.mini.app;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.infrastructure.constant.InfrastructureConstant;
import com.rocogz.syy.infrastructure.entity.menu.CustomMenuIndustry;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: B端小程序的菜单表</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2022/1/24 17:16</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Setter @Getter
@Accessors(chain = true)
public class BasicMiniAppMenu extends IdEntity {

    /**
     * 菜单唯一标识
     */
    private String code;

    /**
     * 菜单名称
     */
    private String title;

    /**
     * 菜单顺序
     */
    private Integer seq;

    /**
     * 小程序appid
     */
    private String appid;

    /**
     * 菜单状态
     * @see InfrastructureConstant#COMMON_STATUS_OPEN
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 最后更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 最后更新人
     */
    private Integer updateUser;


    // ======= 以下是非 PO属性

    /**
     * 给用户授权时，是否否选中该菜单
     */
    @TableField(exist = false)
    private Boolean checked;

    /**
     * 与此菜单关联的操作权限
     */
    @TableField(exist = false)
    private List<BasicMiniAppPermission> permissions;



    /**
     * 菜单关联的行业列表
     */
    @TableField(exist = false)
    private List<MiniAppMenuIndustry> industryList;

    /**
     * 菜单关联的行业名称,多个行业名用逗号分割
     */
    @TableField(exist = false)
    private String industryNames;

    /**
     * 修改人名字
     */
    @TableField(exist = false)
    private String updateUserFullName;



}