package com.rocogz.syy.infrastructure.entity.mini.app;


import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 小程序用户-角色关联关系表 （多对多关系）</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2022/1/24 17:16</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class BasicMiniAppUserRole extends IdEntity {

    /**
     * 用户id,B端小程序发放主体登录账号userId
     * @see AdminUser#id
     */
    private Integer userId;

    /**
     * 小程序角色id(basic_mini_app_role.id)
     * @see BasicMiniAppRole#id
     */
    private Integer roleId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Integer createUser;

}