package com.rocogz.syy.infrastructure.entity.role;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.VersionEntity;
import com.rocogz.syy.infrastructure.entity.permission.Permission;

import java.util.List;

/**
 * <p>
 *  角色
 * </p>
 *
 * @author liangyongtong
 * @since 2020-01-14
 */
@TableName(value = "basic_system_role")
public class Role extends VersionEntity {

    private static final long serialVersionUID=1L;

    public Role() {
    }

    public Role(Integer id) {
        this.id = id;
    }

    /**
     * 角色名称
     */
    private String name;

    /**
     * 角色描述
     */
    private String description;

    /**
     * 是否删除
     */
    private Boolean deleted;

    /**
     * 是否被选中（页面回显用）
     */
    private transient Boolean checked;

    /**
     * 角色类型
     */
    private String type;

    /**
     * 行业code 先存储一个
     * basic_industry_type 中的code
     */
    private String industryCode;

    /**
     * 后台管理角色信息
     */
    @TableField(exist = false)
    private AdminRoleInfo adminRoleInfo;

    /**
     * 角色权限
     */
    private transient List<Permission> permission;

    /**
     * 所属项目编码
     */
    private String systemCode;

    public String getSystemCode() {
        return systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Permission> getPermission() {
        return permission;
    }

    public void setPermission(List<Permission> permission) {
        this.permission = permission;
    }

    public Boolean getChecked() {
        return checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AdminRoleInfo getAdminRoleInfo() {
        return adminRoleInfo;
    }

    public void setAdminRoleInfo(AdminRoleInfo adminRoleInfo) {
        this.adminRoleInfo = adminRoleInfo;
    }

    public String getIndustryCode() {
        return industryCode;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }
}
