package com.rocogz.syy.infrastructure.dto.customerType;

import lombok.Data;

import java.util.List;

@Data
public class CustomerTypeSearchReq {

    private Integer id;
    /**
     * 行业编码
     */
    private String industryCode;
    /**
     * 行业名称
     */
    private String industryName;
    /**
     * 业务编码
     */
    private String businessCode;

    /**
     * 业务类型编码集合-排除用的
     */
    private List<String> businessCodes;

    /**
     * 业务类型编码集合
     */
    private List<String> includeBusinessCodes;

    /**
     * 业务名称
     */
    private String businessName;

    private String customerCode;

    private String customerName;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 需要查询的客户类型编号
     */
    private List<String> includeCustomerCodes;

    /**
     * 需要排除的客户类型编号
     */
    private List<String> excludeCustomerCodes;

    /**
     * 状态
     */
    private String status;

    private Boolean exportFlag = false;

    private int page;

    private int limit;

}
