package com.rocogz.syy.infrastructure.dto.system.adminuser;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.rocogz.syy.infrastructure.dto.base.PageReq;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @author djt
 * @date 2021/7/28
 */
@Data
@Accessors(chain = true)
public class AdminServiceUserSearchReq extends PageReq {

    /**
     * 用户名列表,多个用户名使用逗号分隔
     */
    private List<String> usernameList;

    /**
     * 要排除的用户名列表
     */
    private List<String> excludeUsernameList;

    private String mobile;

    private String name;

    private String status;

    private String agentCode;

    private String agentCodes;

    private String supplierCode;

    private String supplierCodes;

    private String roleId;

    private String registerStatus;

    /**
     * 精确匹配手机号
     */
    private String exactMobile;


    /**
     * 登录用户类型
     */
    private String loginUserType;


    public Map<String, Object> toMap() {
        Map<String, Object> map = Maps.newHashMap();
        if (StringUtils.hasLength(this.mobile)) {
            map.put("mobile", "%" + this.mobile + "%");
        }
        if (StringUtils.hasLength(this.exactMobile)) {
            map.put("exactMobile", this.exactMobile);
        }
        if (StringUtils.hasLength(this.name)) {
            map.put("name", "%" + this.name + "%");
        }
        if (StringUtils.hasLength(this.status)) {
            map.put("status", this.status);
        }
        if (StringUtils.hasLength(this.agentCode)) {
            map.put("agentCode", this.agentCode);
        }
        if (StringUtils.hasLength(this.roleId)) {
            map.put("roleId", this.roleId);
        }
        if (StringUtils.hasLength(this.agentCodes)) {
            map.put("agentCodes", Splitter.on(",").splitToList(this.agentCodes));
        }
        if (StringUtils.hasLength(this.registerStatus)){
            map.put("registerStatus",this.registerStatus);
        }
        if (StringUtils.hasLength(this.loginUserType)) {
            map.put("loginUserType", this.loginUserType);
        }

        if(CollectionUtils.isNotEmpty(usernameList)) {
            map.put("usernameList",usernameList);
        }

        if(CollectionUtils.isNotEmpty(excludeUsernameList)) {
            map.put("excludeUsernameList",excludeUsernameList);
        }

        if (StringUtils.hasLength(this.supplierCode)) {
            map.put("supplierCode", this.supplierCode);
        }

        if (StringUtils.hasLength(this.supplierCodes)) {
            map.put("supplierCodes", Splitter.on(",").splitToList(this.supplierCodes));
        }

        return map;
    }

}
