package com.rocogz.syy.infrastructure.dto.system.adminuser;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author djt
 * @date 2021/3/25
 */
@Data
@Accessors(chain = true)
public class AdminUserSearchDTO {

    /**
     * 用户名-模糊查询
     */
    private String username;

    /**
     * 用户名-全匹配查询
     */
    private String usernameKeyword;

    /**
     * 用户名列表,多个用户名使用逗号分隔
     */
    private List<String> usernameList;

    /**
     * 要排除的用户名列表
     */
    private List<String> excludeUsernameList;

    /**
     * 名称
     */
    private String name;

    /**
     * 角色id
     */
    private String roleId;

    /**
     * 手机号-模糊查询
     */
    private String mobile;

    /**
     * 手机号-全匹配查询
     */
    private String mobileKeyword;

    /**
     * 状态
     */
    private String status;

    /**
     * 注册状态
     */
    private String registerStatus;

    /**
     * 账号类型
     */
    @NotBlank
    private String  type;

    /**
     * 发放主体账户列表
     */
    private  String issuingBodyCodes;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 系统编号
     */
    @NotBlank
    private String systemCode;

    /**
     * 账户性质
     */
    private String issuingBodyUserNature;

    /**
     * 账户类型
     */
    private String issuingBodyUserType;

    /**
     * 后台聚合系统用户类型
     */
    private String adminSystemUserType;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 代理商编号
     */
    private String agentCodes;

    /**
     * 团队编号(多个)
     */
    private String teamCodes;

    /**
     * 是否按团队编号排序
     * 传了false表示不需要，其他情况都需要排序
     */
    private String sortByTeamCode;

    /**
     * 自定义排序方式
     * @see com.rocogz.syy.business.system.adminuser.mapper.SystemAdminUserMapper#search(com.baomidou.mybatisplus.core.metadata.IPage, java.util.Map)
     */
    private String sortBy;

    /**
     * 员工号
     */
    private String employeeNo;


    /**
     * 当前页
     */
    private Integer page;

    /**
     * 页大小
     */
    private Integer limit;

}
