package com.rocogz.syy.infrastructure.dto.system.adminuser;

import com.rocogz.syy.infrastructure.entity.adminuser.AdminUser;
import com.rocogz.syy.infrastructure.entity.adminuser.AdminUserInfo;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.enumerate.UserCreateChannelEnum;
import com.rocogz.syy.infrastructure.valid.group.Create;
import com.rocogz.syy.infrastructure.valid.group.Update;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author djt
 * @date 2021/4/23
 */
@Data
public class UserSaveReq implements Serializable {


    @NotNull(groups = Update.class)
    private Integer userId;


    /**
     * 姓名
     */
    @NotBlank
    private String name;

    /**
     * 用户名
     */
    @NotBlank(groups = Update.class)
    private String username;

    /**
     * 手机号
     */
    @NotBlank
    private String mobile;

    /**
     * 邮箱
     */
    private String email;


    /**
     * 是否需要激活验证
     */
    @NotBlank
    private String registerTag;


    /**
     * 是否需要登录改密码
     */
    private String active;


    /**
     *  发放主体角色信息
     */
    private AdminUserInfo adminUserInfo;

    /**
     * 后台角色id集合
     */
    private  List<Integer> roleId;

    /**
     * 小程序角色id集合
     */
    private  List<Integer> miniAppRoleId;

    /**
     * 需要添加的用户权限
     */
    private  List<UserDataPermission> newUserDataPermissions;

    /**
     * 需要移除的数据权限
     */
    private List<UserDataPermission> removeUserDataPermissions;

    /**
     * 所属项目编码
     */
    private String systemCode;

    /**
     * 所属项目编码
     */
    @NotBlank
    private String type;


    /**
     * 创建人
     */
    private AdminUser createUser;

    /**
     * 更新人
     */
    private AdminUser updateUser;

    /**
     * 密码
     */
    private String password;


    /**
     * 创建来源
     * @see UserCreateChannelEnum
     */
    private String srcChannel;


    /**
     * 允许PC端登录 Y/N
     */
    private String allowPcLogin;

    /**
     * 允许小程序端登录（B端)
     */
    private String allowMiniAppLogin;

    /**
     * Y/N 激活状态 直接激活
     *
     * 如果传递的Y 则直接修改激活标记
     *
     */
    private String registerStatus;

    /**
     * 页面传递过来 本级，本级以及下级 仅限本人
     *
     */
    private String dpType;

    /**
     * 状态
     */
    private String status;


    /**
     * 是否移除客户权限
     */
    private String removeALLCustomerDP;



}
