package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 用户在管理端小程序微信信息
 *
 * @author djt
 * @date 2022/2/14
 */
@TableName("basic_user_mini_app_info")
@Data
@Accessors(chain = true)
public class UserMiniAppInfo extends IdEntity {

    /**
     * userId
     */
    private Integer userId;

    /**
     * 用户名
     */
    private String username;

    /**
     * 所在小程序miniAppid：wxc39104569ba2b69c ->B端礼赠程序、wx8a25c2e131146908 ->管理端小程序
     */
    private String belongMiniAppid;

    /**
     * 管理端小程序openId
     */
    private String openId;

    /**
     * 用户在公众号的openId
     */
    private String wxOpenId;

    /**
     * 用户在公众号的unionId
     */
    private String unionId;

    /**
     * 是否推送微信公众号消息：Y-是、N-否
     */
    private String pushWxMsg;

    /**
     * 绑定方式：REALNAMEAUTH-实名认证绑定、WXBIND-微信直接绑定
     */
    private String bindType;
}
