package com.rocogz.syy.infrastructure.entity.app.config;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Description: 小程序版块配置数据源entity
 * @date：2023/06/13
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("basic_mini_app_section_config_source")
public class BasicMiniAppSectionConfigSource extends IdEntity {

    private static final long serialVersionUID = 913398166902904404L;

    /**
    * 版块编号
    */
    private String code;
    
    /**
    * 版块名称
    */
    private String name;
    
    /**
    * 版块可见性（Y-显示、N-隐藏）
    */
    private String isShow;
    
    /**
    * 排序号
    */
    private Integer sort;

    /**
     * 配置内容
     */
    @TableField(exist = false)
    private List<BasicMiniAppSectionConfigContentSource> configContentSources;
}