package com.rocogz.syy.infrastructure.entity.menu;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.infrastructure.constant.InfrastructureConstant;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 发放主体menu，集成商menu
 * @author hsf
 * @since 2020-09-01
 */
@TableName(value = "basic_custom_menu")
public class CustomMenu extends IdEntity {

    /**
     * 菜单名称，例如：机构账号管理
     */
    private String title;

    private String icon;

    /**
     * 父menuId
     */
    private Integer pid;

    private Integer seq;

    private Integer level;

    /**
     * 启用/停用
     * @see InfrastructureConstant#COMMON_STATUS_OPEN
     */
    private String status;

    /**
     * 关联的系统菜单id
     * @see Menu#id
     */
    private Integer menuId;

    /**
     * @see InfrastructureConstant.DictUserType#PLATFORM
     */
    private String type;

    /**
     * menu所在路径，例如： 0.1.23
     * path构成：祖先节点的id.自己的id
     */
    private String path;

    /**
     * 标记该菜单是否对应basic_menu的菜单,Y/N
     */
    private String relateSysMenu;


    @TableField(exist = false)
    private String pTitle;


    @TableField(exist = false)
    private Menu menu;

    @TableField(exist = false)
    private Boolean checked;

    /**
     * 所属项目编码
     */
    private String systemCode;

    /**
     * 菜单关联的行业列表
     */
    @TableField(exist = false)
    private List<CustomMenuIndustry> industryList;

    /**
     * 菜单关联的行业名称,多个行业名用逗号分割
     */
    @TableField(exist = false)
    private String industryNames;


    public String getSystemCode() {
        return systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Integer getPid() {
        return pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getMenuId() {
        return menuId;
    }

    public void setMenuId(Integer menuId) {
        this.menuId = menuId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRelateSysMenu() {
        return relateSysMenu;
    }

    public void setRelateSysMenu(String relateSysMenu) {
        this.relateSysMenu = relateSysMenu;
    }

    public String getPTitle() {
        return pTitle;
    }

    public void setPTitle(String pTitle) {
        this.pTitle = pTitle;
    }

    public Menu getMenu() {
        return menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public Boolean getChecked() {
        return checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }



    public String getIndustryNames() {
        return industryNames;
    }

    public void setIndustryNames(String industryNames) {
        this.industryNames = industryNames;
    }

    public List<CustomMenuIndustry> getIndustryList() {
        return industryList;
    }

    public void setIndustryList(List<CustomMenuIndustry> industryList) {
        this.industryList = industryList;
    }

}