package com.rocogz.syy.infrastructure.entity.mini.app;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.infrastructure.entity.industryType.IndustryType;
import com.rocogz.syy.infrastructure.entity.menu.CustomMenu;
import lombok.Getter;
import lombok.Setter;

/**
 * B端小程序menu 所关联绑定的行业 (多对多关系)
 *
 * @author hhl
 * @since 2023-09-01
 */
@Setter
@Getter
@TableName(value = "basic_mini_app_menu_industry")
public class MiniAppMenuIndustry extends IdEntity {

    /**
     * 发放主体menuId
     *
     * @see BasicMiniAppMenu#id
     */
    private Integer menuId;

    /**
     * 关联的行业编号
     *
     * @see IndustryType#industryCode
     */
    private String industryCode;

    // 以下用来展示,非PO属性

    @TableField(exist = false)
    private  String industryName;


}